/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractReplyToCommenAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorRichTextPart;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.ui.AbstractDuplicateDetector;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.search.SearchHitCollector;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskEditorDescriptionPart
extends TaskEditorRichTextPart {
    private static final String LABEL_SEARCH_DUPS = "Search";
    private static final String LABEL_SELECT_DETECTOR = "Duplicate Detection";

    public TaskEditorDescriptionPart(AbstractTaskEditorPage taskEditorPage, RepositoryTaskAttribute attribute) {
        super(taskEditorPage, attribute);
    }

    private void addDuplicateDetection(Composite composite, FormToolkit toolkit) {
        ArrayList<AbstractDuplicateDetector> allCollectors = new ArrayList<AbstractDuplicateDetector>();
        if (this.getDuplicateSearchCollectorsList() != null) {
            allCollectors.addAll(this.getDuplicateSearchCollectorsList());
        }
        if (!allCollectors.isEmpty()) {
            Section duplicatesSection = toolkit.createSection(composite, 514);
            duplicatesSection.setText(LABEL_SELECT_DETECTOR);
            duplicatesSection.setLayout((Layout)new GridLayout());
            GridDataFactory.fillDefaults().indent(-1, 15).applyTo((Control)duplicatesSection);
            Composite relatedBugsComposite = toolkit.createComposite((Composite)duplicatesSection);
            relatedBugsComposite.setLayout((Layout)new GridLayout(4, false));
            relatedBugsComposite.setLayoutData((Object)new GridData(256));
            duplicatesSection.setClient((Control)relatedBugsComposite);
            Label duplicateDetectorLabel = new Label(relatedBugsComposite, 16384);
            duplicateDetectorLabel.setText("Detector:");
            final CCombo duplicateDetectorChooser = new CCombo(relatedBugsComposite, 0x800008);
            toolkit.adapt((Control)duplicateDetectorChooser, true, true);
            duplicateDetectorChooser.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            duplicateDetectorChooser.setFont(TEXT_FONT);
            duplicateDetectorChooser.setLayoutData((Object)GridDataFactory.swtDefaults().hint(150, -1).create());
            Collections.sort(allCollectors, new Comparator<AbstractDuplicateDetector>(){

                @Override
                public int compare(AbstractDuplicateDetector c1, AbstractDuplicateDetector c2) {
                    return c1.getName().compareToIgnoreCase(c2.getName());
                }
            });
            for (AbstractDuplicateDetector detector : allCollectors) {
                duplicateDetectorChooser.add(detector.getName());
            }
            duplicateDetectorChooser.select(0);
            duplicateDetectorChooser.setEnabled(true);
            duplicateDetectorChooser.setData(allCollectors);
            if (allCollectors.size() > 0) {
                Button searchForDuplicates = toolkit.createButton(relatedBugsComposite, LABEL_SEARCH_DUPS, 0);
                GridData searchDuplicatesButtonData = new GridData(32);
                searchForDuplicates.setLayoutData((Object)searchDuplicatesButtonData);
                searchForDuplicates.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        String selectedDetector = duplicateDetectorChooser.getItem(duplicateDetectorChooser.getSelectionIndex());
                        TaskEditorDescriptionPart.this.searchForDuplicates(selectedDetector);
                    }
                });
            }
            toolkit.paintBordersFor(relatedBugsComposite);
        }
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        super.createControl(parent, toolkit);
        Composite composite = (Composite)this.getControl();
        this.addDuplicateDetection(composite, toolkit);
    }

    @Override
    protected void fillToolBar(ToolBarManager toolBar) {
        AbstractReplyToCommenAction replyAction = new AbstractReplyToCommenAction(this.getTaskEditorPage(), 0){

            protected String getReplyText() {
                return TaskEditorDescriptionPart.this.getTaskData().getDescription();
            }
        };
        toolBar.add((IAction)replyAction);
    }

    protected SearchHitCollector getDuplicateSearchCollector(String name) {
        String duplicateDetectorName = name.equals("default") ? "Stack Trace" : name;
        Set<AbstractDuplicateDetector> allDetectors = this.getDuplicateSearchCollectorsList();
        for (AbstractDuplicateDetector detector : allDetectors) {
            if (!detector.getName().equals(duplicateDetectorName)) continue;
            return detector.getSearchHitCollector(this.getTaskRepository(), this.getTaskData());
        }
        return null;
    }

    protected Set<AbstractDuplicateDetector> getDuplicateSearchCollectorsList() {
        HashSet<AbstractDuplicateDetector> duplicateDetectors = new HashSet<AbstractDuplicateDetector>();
        for (AbstractDuplicateDetector abstractDuplicateDetector : TasksUiPlugin.getDefault().getDuplicateSearchCollectorsList()) {
            if (abstractDuplicateDetector.getKind() != null && !abstractDuplicateDetector.getKind().equals(this.getConnector().getConnectorKind())) continue;
            duplicateDetectors.add(abstractDuplicateDetector);
        }
        return duplicateDetectors;
    }

    public boolean searchForDuplicates(String duplicateDetectorName) {
        SearchHitCollector collector = this.getDuplicateSearchCollector(duplicateDetectorName);
        if (collector != null) {
            NewSearchUI.runQueryInBackground((ISearchQuery)collector);
            return true;
        }
        return false;
    }
}

