/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.mylyn.internal.tasks.ui.editors.IRepositoryTaskSelection;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskComment;

public class RepositoryTaskOutlineNode
implements IRepositoryTaskSelection {
    public static final String LABEL_DESCRIPTION = "Description";
    public static final String LABEL_COMMENTS = "Comments";
    public static final String LABEL_NEW_COMMENT = "New Comment";
    protected String id;
    protected String server;
    private String kind;
    private String key;
    private ArrayList<RepositoryTaskOutlineNode> nodeChildren;
    private RepositoryTaskOutlineNode parent;
    private Object data = null;
    private String bugSummary;
    private boolean fromEditor = false;
    private boolean isCommentHeader = false;
    private boolean isDescription = false;

    public RepositoryTaskOutlineNode(String id, String server, String kind, String key, Object data, String summary) {
        this.id = id;
        this.server = server;
        this.kind = kind;
        this.key = key;
        this.nodeChildren = null;
        this.data = data;
        this.parent = null;
        this.bugSummary = summary;
    }

    public boolean isFromEditor() {
        return this.fromEditor;
    }

    public RepositoryTaskOutlineNode[] getChildren() {
        return this.nodeChildren == null ? new RepositoryTaskOutlineNode[]{} : this.nodeChildren.toArray(new RepositoryTaskOutlineNode[this.nodeChildren.size()]);
    }

    public void addChild(RepositoryTaskOutlineNode bugNode) {
        if (this.nodeChildren == null) {
            this.nodeChildren = new ArrayList();
        }
        bugNode.setParent(this);
        this.nodeChildren.add(bugNode);
    }

    public String getKey() {
        return this.key;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof RepositoryTaskOutlineNode) {
            RepositoryTaskOutlineNode bugNode = (RepositoryTaskOutlineNode)arg0;
            return this.getKey().equals(bugNode.getKey());
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String getName() {
        return this.getKey();
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public static RepositoryTaskOutlineNode parseBugReport(RepositoryTaskData bug, boolean hasNewComment) {
        if (bug != null) {
            return RepositoryTaskOutlineNode.parseExistingBugReport(bug, hasNewComment);
        }
        return null;
    }

    public static RepositoryTaskOutlineNode parseBugReport(RepositoryTaskData bug) {
        return RepositoryTaskOutlineNode.parseBugReport(bug, true);
    }

    protected static RepositoryTaskOutlineNode parseExistingBugReport(RepositoryTaskData bug, boolean hasNewComment) {
        String bugId = bug.getId();
        String bugServer = bug.getRepositoryUrl();
        RepositoryTaskOutlineNode topNode = new RepositoryTaskOutlineNode(bugId, bugServer, bug.getRepositoryKind(), bug.getLabel(), bug, bug.getSummary());
        RepositoryTaskOutlineNode desc = new RepositoryTaskOutlineNode(bugId, bugServer, bug.getRepositoryKind(), LABEL_DESCRIPTION, bug.getDescription(), bug.getSummary());
        desc.setIsDescription(true);
        topNode.addChild(desc);
        RepositoryTaskOutlineNode comments = null;
        for (TaskComment taskComment : bug.getComments()) {
            if (taskComment.getNumber() == 0) continue;
            if (comments == null) {
                comments = new RepositoryTaskOutlineNode(bugId, bugServer, bug.getRepositoryKind(), LABEL_COMMENTS, taskComment, bug.getSummary());
                comments.setIsCommentHeader(true);
            }
            comments.addChild(new RepositoryTaskOutlineNode(bugId, bugServer, bug.getRepositoryKind(), taskComment.getCreated(), taskComment, bug.getSummary()));
        }
        if (comments != null) {
            topNode.addChild(comments);
        }
        if (hasNewComment) {
            topNode.addChild(new RepositoryTaskOutlineNode(bugId, bugServer, bug.getRepositoryKind(), LABEL_NEW_COMMENT, null, bug.getSummary()));
        }
        RepositoryTaskOutlineNode titleNode = new RepositoryTaskOutlineNode(bugId, bugServer, bug.getRepositoryKind(), "BugReport Object", null, bug.getSummary());
        titleNode.addChild(topNode);
        return titleNode;
    }

    public boolean hasComment() {
        return this.data instanceof TaskComment && !this.key.toLowerCase(Locale.ENGLISH).equals("comments");
    }

    public TaskComment getComment() {
        return this.hasComment() ? (TaskComment)this.data : null;
    }

    public void setComment(TaskComment taskComment) {
        this.data = taskComment;
    }

    public String getContents() {
        return this.key;
    }

    public void setContents(String contents) {
        this.key = contents;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRepositoryUrl() {
        return this.server;
    }

    public String getConnectorKind() {
        return this.kind;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public boolean isEmpty() {
        return this.server == null || this.getContents() == null && this.getComment() == null;
    }

    public RepositoryTaskOutlineNode getParent() {
        return this.parent;
    }

    public void setParent(RepositoryTaskOutlineNode parent) {
        this.parent = parent;
    }

    public boolean isCommentHeader() {
        return this.isCommentHeader;
    }

    public boolean isDescription() {
        return this.isDescription;
    }

    public void setIsCommentHeader(boolean isCommentHeader) {
        this.isCommentHeader = isCommentHeader;
    }

    public void setIsDescription(boolean isDescription) {
        this.isDescription = isDescription;
    }

    public String getBugSummary() {
        return this.bugSummary;
    }
}

