/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.tasks.core.AbstractAttachmentHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

public class RepositoryAttachmentEditorInput
extends PlatformObject
implements IStorageEditorInput {
    private RepositoryAttachment attachment;
    private RepositoryAttachmentStorage storage;
    private TaskRepository repository;

    public RepositoryAttachmentEditorInput(TaskRepository repository, RepositoryAttachment att) {
        this.attachment = att;
        this.storage = new RepositoryAttachmentStorage();
        this.repository = repository;
    }

    public IStorage getStorage() throws CoreException {
        return this.storage;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.storage.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "Repository Attachment: " + this.attachment.getId() + " [" + this.attachment.getUrl() + "]";
    }

    class RepositoryAttachmentStorage
    extends PlatformObject
    implements IStorage {
        private static final String ATTR_FILENAME = "filename";
        private static final String ATTACHMENT_DEFAULT_NAME = "attachment";
        private static final String CTYPE_ZIP = "zip";
        private static final String CTYPE_OCTET_STREAM = "octet-stream";
        private static final String CTYPE_TEXT = "text";
        private static final String CTYPE_HTML = "html";

        RepositoryAttachmentStorage() {
        }

        public InputStream getContents() throws CoreException {
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(RepositoryAttachmentEditorInput.this.repository.getConnectorKind());
            AbstractAttachmentHandler handler = connector.getAttachmentHandler();
            return handler.getAttachmentAsStream(RepositoryAttachmentEditorInput.this.repository, RepositoryAttachmentEditorInput.this.attachment, (IProgressMonitor)new NullProgressMonitor());
        }

        public IPath getFullPath() {
            return null;
        }

        public String getName() {
            String name = RepositoryAttachmentEditorInput.this.attachment.getAttributeValue(ATTR_FILENAME);
            if (name == null || "".equals(name)) {
                String ctype = RepositoryAttachmentEditorInput.this.attachment.getContentType();
                name = ctype.endsWith(CTYPE_HTML) ? "attachment.html" : (ctype.startsWith(CTYPE_TEXT) ? "attachment.txt" : (ctype.endsWith(CTYPE_OCTET_STREAM) ? ATTACHMENT_DEFAULT_NAME : (ctype.endsWith(CTYPE_ZIP) ? "attachment.zip" : "attachment." + ctype.substring(ctype.indexOf("/") + 1))));
            }
            if (name.endsWith(".patch")) {
                name = String.valueOf(name) + ".txt";
            }
            return name;
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

