/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttributeManager;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.ui.DatePicker;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class DateAttributeEditor
extends AbstractAttributeEditor {
    private DatePicker deadlinePicker;

    public DateAttributeEditor(AttributeManager manager, RepositoryTaskAttribute taskAttribute) {
        super(manager, taskAttribute);
    }

    public void createControl(Composite composite, FormToolkit toolkit) {
        Composite dateWithClear = toolkit.createComposite(composite);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 1;
        dateWithClear.setLayout((Layout)layout);
        String value = "";
        Date date = this.getValue();
        if (date != null) {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
            value = f.format(date);
        }
        this.deadlinePicker = new DatePicker(dateWithClear, 2048, value);
        this.deadlinePicker.setEnabled(!this.getTaskAttribute().isReadOnly());
        this.deadlinePicker.setFont(TEXT_FONT);
        this.deadlinePicker.setDatePattern("yyyy-MM-dd");
        this.deadlinePicker.addPickerSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Calendar cal = DateAttributeEditor.this.deadlinePicker.getDate();
                if (cal != null) {
                    DateAttributeEditor.this.setValue(cal.getTime());
                } else {
                    DateAttributeEditor.this.setValue(null);
                    DateAttributeEditor.this.deadlinePicker.setDate(null);
                }
            }
        });
        ImageHyperlink clearDeadlineDate = toolkit.createImageHyperlink(dateWithClear, 0);
        clearDeadlineDate.setImage(TasksUiImages.getImage(TasksUiImages.REMOVE));
        clearDeadlineDate.setToolTipText("Clear");
        clearDeadlineDate.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DateAttributeEditor.this.setValue(null);
                DateAttributeEditor.this.deadlinePicker.setDate(null);
            }
        });
        this.setControl((Control)dateWithClear);
    }

    public Date getValue() {
        return this.getAttributeMapper().getDateValue(this.getTaskAttribute());
    }

    public void setValue(Date date) {
        this.getAttributeMapper().setDateValue(this.getTaskAttribute(), date);
        this.attributeChanged();
    }

    public void decorate(Color color) {
        this.deadlinePicker.setBackground(color);
    }
}

