/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.mylyn.internal.tasks.ui.editors.IRepositoryTaskSelection;

public class ContentOutlineTools {
    public static final String OFFLINE_SERVER_DEFAULT = "[local]";

    public static String getHandle(IRepositoryTaskSelection taskSelection) {
        String handle = String.valueOf(taskSelection.getRepositoryUrl()) + ";" + taskSelection.getId();
        if (taskSelection.hasComment()) {
            int number = taskSelection.getComment().getNumber() + 1;
            handle = String.valueOf(handle) + ";" + number;
        } else if (taskSelection.isCommentHeader()) {
            handle = String.valueOf(handle) + ";1";
        } else if (taskSelection.isDescription()) {
            handle = String.valueOf(handle) + ";0";
        }
        return handle;
    }

    public static String getName(IRepositoryTaskSelection taskSelection) {
        String name = String.valueOf(taskSelection.getRepositoryUrl()) + ": Bug#: " + taskSelection.getId() + ": " + taskSelection.getBugSummary();
        if (taskSelection.hasComment()) {
            name = String.valueOf(name) + " : Comment#: " + taskSelection.getComment().getNumber();
        } else if (taskSelection.isCommentHeader()) {
            name = String.valueOf(name) + " : Comment Header";
        } else if (taskSelection.isDescription()) {
            name = String.valueOf(name) + ": Description";
        }
        return name;
    }
}

