/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.mylyn.internal.tasks.core.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.ui.editors.IAttributeManagerListener;
import org.eclipse.mylyn.tasks.core.RepositoryOperation;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeManager {
    private Set<RepositoryTaskAttribute> changedAttributes = new HashSet<RepositoryTaskAttribute>();
    private List<IAttributeManagerListener> listeners;
    private Set<RepositoryTaskAttribute> oldEdits;
    private RepositoryTaskData oldTaskData;
    private String storageId;
    private String storageUrl;
    private RepositoryTaskData taskData;
    private TaskDataManager taskDataManager;
    private final TaskRepository taskRepository;

    public AttributeManager(TaskRepository taskRepository, String storageUrl, String storageId) {
        this.taskRepository = taskRepository;
        this.storageUrl = storageUrl;
        this.storageId = storageId;
        this.taskDataManager = TasksUiPlugin.getTaskDataManager();
    }

    public void addAttributeManagerListener(IAttributeManagerListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IAttributeManagerListener>();
        }
        this.listeners.add(listener);
    }

    public void attributeChanged(RepositoryTaskAttribute attribute) {
        this.changedAttributes.add(attribute);
        if (this.listeners != null) {
            IAttributeManagerListener[] iAttributeManagerListenerArray = this.listeners.toArray(new IAttributeManagerListener[0]);
            int n = iAttributeManagerListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAttributeManagerListener listener = iAttributeManagerListenerArray[n2];
                listener.attributeChanged(attribute);
                ++n2;
            }
        }
    }

    private Set<RepositoryTaskAttribute> getOldEdits() {
        return this.oldEdits;
    }

    public RepositoryTaskData getOldTaskData() {
        return this.oldTaskData;
    }

    public String getStorageId() {
        return this.storageId;
    }

    public String getStorageUrl() {
        return this.storageUrl;
    }

    public RepositoryTaskData getTaskData() {
        return this.taskData;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public boolean hasIncomingChanges(RepositoryTaskAttribute taskAttribute) {
        RepositoryTaskData oldTaskData = this.getOldTaskData();
        if (oldTaskData == null) {
            return false;
        }
        if (this.hasOutgoingChanges(taskAttribute)) {
            return false;
        }
        RepositoryTaskAttribute oldAttribute = oldTaskData.getAttribute(taskAttribute.getId());
        if (oldAttribute == null) {
            return true;
        }
        if (oldAttribute.getValue() != null && !oldAttribute.getValue().equals(taskAttribute.getValue())) {
            return true;
        }
        return oldAttribute.getValues() != null && !oldAttribute.getValues().equals(taskAttribute.getValues());
    }

    public boolean hasOutgoingChanges(RepositoryTaskAttribute taskAttribute) {
        return this.getOldEdits().contains(taskAttribute);
    }

    boolean hasVisibleOutgoingChanges(RepositoryTaskData taskData) {
        if (taskData == null) {
            return false;
        }
        for (RepositoryTaskAttribute attribute : taskData.getAttributes()) {
            if (attribute.isHidden() || !this.hasOutgoingChanges(attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        return !this.changedAttributes.isEmpty();
    }

    public boolean isNewComment(TaskComment comment) {
        if (this.getOldTaskData() != null) {
            return comment.getNumber() > this.getOldTaskData().getComments().size();
        }
        return false;
    }

    public void operationChanged(RepositoryOperation operation) {
    }

    public void refreshInput() {
        this.setTaskData(this.taskDataManager.getEditableCopy(this.storageUrl, this.storageId));
        this.setOldTaskData(this.taskDataManager.getOldTaskData(this.storageUrl, this.storageId));
        this.setOldEdits(this.taskDataManager.getEdits(this.storageUrl, this.storageId));
    }

    public void removeAttributeManagerListener(IAttributeManagerListener listener) {
        this.listeners.remove(listener);
    }

    public void save() {
        TasksUiPlugin.getTaskDataManager().saveEdits(this.storageUrl, this.storageId, Collections.unmodifiableSet(this.changedAttributes));
        this.changedAttributes.clear();
    }

    private void setOldEdits(Set<RepositoryTaskAttribute> oldEdits) {
        this.oldEdits = oldEdits;
    }

    private void setOldTaskData(RepositoryTaskData oldTaskData) {
        this.oldTaskData = oldTaskData;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public void setStorageUrl(String storageUrl) {
        this.storageUrl = storageUrl;
    }

    private void setTaskData(RepositoryTaskData taskData) {
        this.taskData = taskData;
    }
}

