/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttributeManager;
import org.eclipse.mylyn.internal.tasks.ui.editors.DateAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.LongTextAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.MultiSelectionAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.SimpleDateAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.SingleSelectionAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskDependendyAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TextAttributeEditor;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;

public class AttributeEditorFactory {
    private final AttributeManager manager;

    public AttributeEditorFactory(AttributeManager manager) {
        this.manager = manager;
    }

    public AbstractAttributeEditor createEditor(String type, RepositoryTaskAttribute taskAttribute) {
        Assert.isNotNull((Object)type);
        if ("date".equals(type)) {
            if ("task.common.date.created".equals(taskAttribute.getId()) || "task.common.date.modified".equals(taskAttribute.getId())) {
                return new SimpleDateAttributeEditor(this.manager, taskAttribute);
            }
            return new DateAttributeEditor(this.manager, taskAttribute);
        }
        if ("longText".equals(type)) {
            return new LongTextAttributeEditor(this.manager, taskAttribute);
        }
        if ("multiSelect".equals(type)) {
            return new MultiSelectionAttributeEditor(this.manager, taskAttribute);
        }
        if ("shortText".equals(type)) {
            return new TextAttributeEditor(this.manager, taskAttribute);
        }
        if ("singleSelect".equals(type)) {
            return new SingleSelectionAttributeEditor(this.manager, taskAttribute);
        }
        if ("taskDepenedency".equals(type)) {
            return new TaskDependendyAttributeEditor(this.manager, taskAttribute);
        }
        throw new IllegalArgumentException("Unsupported editor type: \"" + type + "\"");
    }
}

