/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.text.DecimalFormat;

public class AttachmentSizeFormatter {
    public static final String UNKNOWN_SIZE = "-";

    public static String format(String sizeInBytes) {
        if (sizeInBytes == null) {
            return UNKNOWN_SIZE;
        }
        int size = 0;
        try {
            size = Integer.parseInt(sizeInBytes);
        }
        catch (NumberFormatException numberFormatException) {
            return UNKNOWN_SIZE;
        }
        if (size < 0) {
            return UNKNOWN_SIZE;
        }
        if (size < 1024) {
            if (size == 1) {
                return "1 byte";
            }
            DecimalFormat fmt = new DecimalFormat("0 bytes");
            return fmt.format(size);
        }
        if (size >= 1024 && size <= 1048575) {
            double formattedValue = (double)size / 1024.0;
            DecimalFormat fmt = new DecimalFormat("0.00 KB");
            return fmt.format(formattedValue);
        }
        if (size >= 0x100000 && size <= 0x3FFFFFFF) {
            double formattedValue = (double)size / 1048576.0;
            DecimalFormat fmt = new DecimalFormat("0.00 MB");
            return fmt.format(formattedValue);
        }
        double formattedValue = (double)size / 1.073741824E9;
        DecimalFormat fmt = new DecimalFormat("0.00 GB");
        return fmt.format(formattedValue);
    }
}

