/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.action.Action;
import org.eclipse.mylyn.internal.tasks.core.CommentQuoter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorPage;

public abstract class AbstractReplyToCommenAction
extends Action {
    private static final String LABEL_REPLY = "Reply";
    private final int commentNum;
    private final AbstractTaskEditorPage editor;

    public AbstractReplyToCommenAction(AbstractTaskEditorPage editor, int commentNum) {
        this.editor = editor;
        this.commentNum = commentNum;
        this.setImageDescriptor(TasksUiImages.REPLY);
        this.setToolTipText(LABEL_REPLY);
    }

    protected abstract String getReplyText();

    public void run() {
        StringBuilder sb = new StringBuilder();
        sb.append(" (In reply to comment #" + this.commentNum + ")\n");
        String text = this.getText();
        if (text != null) {
            CommentQuoter quoter = new CommentQuoter();
            sb.append(quoter.quote(text));
        }
        this.editor.appendTextToNewComment(sb.toString());
    }
}

