/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class ToggleTaskActivationAction
extends Action
implements ITaskActivityListener {
    public static final String ID = "org.eclipse.mylyn.tasks.ui.actions.task.activation.toggle";
    private static final String LABEL_ACTIVATE = "Activate Task";
    private static final String LABEL_DEACTIVATE = "Deactivate Task";
    private AbstractTask task;
    private IToolBarManager toolBarManager;

    public ToggleTaskActivationAction(AbstractTask task, IToolBarManager toolBarManager) {
        this.task = task;
        this.toolBarManager = toolBarManager;
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.TASK_ACTIVE_CENTERED);
        this.update();
        TasksUiPlugin.getTaskListManager().addActivityListener(this);
    }

    public void dispose() {
        TasksUiPlugin.getTaskListManager().removeActivityListener(this);
    }

    private void update() {
        this.setChecked(this.task.isActive());
        if (this.task.isActive()) {
            this.setText(LABEL_DEACTIVATE);
            this.setToolTipText(LABEL_DEACTIVATE);
        } else {
            this.setText(LABEL_ACTIVATE);
            this.setToolTipText(LABEL_ACTIVATE);
        }
    }

    public void run() {
        if (!this.task.isActive()) {
            TasksUiPlugin.getTaskListManager().activateTask(this.task);
        } else {
            TasksUiPlugin.getTaskListManager().deactivateTask(this.task);
        }
        this.update();
    }

    public void activityChanged(ScheduledTaskContainer week) {
    }

    public void taskActivated(AbstractTask task) {
        this.update();
        this.toolBarManager.update(true);
    }

    public void taskDeactivated(AbstractTask task) {
        this.update();
        this.toolBarManager.update(true);
    }

    public void taskListRead() {
    }
}

