/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskImportAction
extends Action
implements IViewActionDelegate {
    protected ISelection selection;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run() {
        File file;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dialog = new FileDialog(shell);
        dialog.setFilterExtensions(new String[]{"*.xml.zip"});
        String path = dialog.open();
        if (path != null && (file = new File(path)).isFile()) {
            HashMap<AbstractTask, InteractionContext> taskContexts = new HashMap<AbstractTask, InteractionContext>();
            List<AbstractTask> readTasks = TasksUiPlugin.getTaskListManager().getTaskListWriter().readTasks(file);
            for (AbstractTask task : readTasks) {
                task.setActive(false);
                taskContexts.put(task, ContextCorePlugin.getContextManager().loadContext(task.getHandleIdentifier(), file));
            }
            Set<TaskRepository> repositories = TasksUiPlugin.getTaskListManager().getTaskListWriter().readRepositories(file);
            if (taskContexts.size() > 0) {
                this.importTasks(taskContexts, repositories, shell);
                this.refreshTaskListView();
            } else {
                MessageDialog.openError((Shell)shell, (String)"Task Import Error", (String)"The specified file is not an exported task. Please, check that you have provided the correct file.");
                return;
            }
        }
    }

    public void refreshTaskListView() {
        if (TaskListView.getFromActivePerspective() != null) {
            TaskListView.getFromActivePerspective().refresh();
        }
    }

    public void importTasks(Map<AbstractTask, InteractionContext> taskContexts, Set<TaskRepository> repositories, Shell shell) {
        TasksUiPlugin.getRepositoryManager().insertRepositories(repositories, TasksUiPlugin.getDefault().getRepositoriesFilePath());
        for (AbstractTask loadedTask : taskContexts.keySet()) {
            TaskList taskList = TasksUiPlugin.getTaskListManager().getTaskList();
            if (taskList.getTask(loadedTask.getHandleIdentifier()) != null) {
                boolean confirmed = MessageDialog.openConfirm((Shell)shell, (String)"Mylyn Information", (String)("Task '" + loadedTask.getSummary() + "' already exists. Do you want to override it's context with the source?"));
                if (!confirmed) continue;
                ContextCorePlugin.getContextManager().importContext(taskContexts.get(loadedTask));
                continue;
            }
            ContextCorePlugin.getContextManager().importContext(taskContexts.get(loadedTask));
            TasksUiPlugin.getTaskListManager().getTaskList().insertTask(loadedTask, null, null);
        }
    }
}

