/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class SynchronizeEditorAction
extends BaseSelectionListenerAction {
    private static final String LABEL = "Synchronize";
    private static final String TOOLTIP = "Synchronize Incoming Changes";
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.synchronize.editor";

    public SynchronizeEditorAction() {
        super(LABEL);
        this.setToolTipText(TOOLTIP);
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.REFRESH_SMALL);
    }

    public void run() {
        if (super.getStructuredSelection() != null) {
            Iterator iter = super.getStructuredSelection().iterator();
            while (iter.hasNext()) {
                this.runWithSelection(iter.next());
            }
        }
    }

    private void runWithSelection(final Object selectedObject) {
        AbstractRepositoryConnector connector;
        Object editor;
        AbstractTask repositoryTask = null;
        if (selectedObject instanceof TaskEditor) {
            editor = (TaskEditor)selectedObject;
            AbstractTask task = ((TaskEditor)editor).getTaskEditorInput().getTask();
            if (task != null) {
                repositoryTask = task;
            }
        } else if (selectedObject instanceof AbstractRepositoryTaskEditor) {
            editor = (AbstractRepositoryTaskEditor)((Object)selectedObject);
            repositoryTask = ((AbstractRepositoryTaskEditor)((Object)editor)).getRepositoryTask();
        }
        if (repositoryTask != null && (connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repositoryTask.getConnectorKind())) != null) {
            TasksUiPlugin.getSynchronizationManager().synchronize(connector, repositoryTask, true, (IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (selectedObject instanceof TaskEditor) {
                                TaskEditor editor = (TaskEditor)selectedObject;
                                editor.refreshEditorContents();
                            } else if (selectedObject instanceof AbstractRepositoryTaskEditor) {
                                ((AbstractRepositoryTaskEditor)((Object)selectedObject)).refreshEditor();
                            }
                        }
                    });
                }
            });
        }
    }
}

