/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.actions.AbstractTaskRepositoryAction;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class RefreshRepositoryTasksAction
extends AbstractTaskRepositoryAction
implements IViewActionDelegate {
    private static final String ID = "org.eclipse.mylyn.tasklist.repositories.refreshAllTasks";

    public RefreshRepositoryTasksAction() {
        super("Refresh All Tasks");
        this.setId(ID);
        this.setEnabled(false);
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        for (Object selectedObject : selection) {
            if (!(selectedObject instanceof TaskRepository)) continue;
            TaskRepository repository = (TaskRepository)selectedObject;
            this.synchronizeAllTasks(repository);
        }
    }

    private void synchronizeAllTasks(TaskRepository repository) {
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
        if (connector != null) {
            Set repositoryTasks = TasksUiPlugin.getTaskListManager().getTaskList().getRepositoryTasks(repository.getUrl());
            TasksUiPlugin.getSynchronizationManager().synchronize(connector, repositoryTasks, true, null);
        }
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectionChanged((IStructuredSelection)selection);
    }
}

