/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Iterator;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class OpenWithBrowserAction
extends BaseSelectionListenerAction {
    private static final String LABEL = "Open with Browser";
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.open.browser";

    public OpenWithBrowserAction() {
        super(LABEL);
        this.setToolTipText(LABEL);
        this.setId(ID);
    }

    public void run() {
        if (super.getStructuredSelection() != null) {
            Iterator iter = super.getStructuredSelection().iterator();
            while (iter.hasNext()) {
                this.runWithSelection(iter.next());
            }
        }
    }

    private void runWithSelection(Object selectedObject) {
        String urlString = null;
        if (selectedObject instanceof AbstractTask) {
            AbstractTask task = (AbstractTask)selectedObject;
            if (task.hasValidUrl()) {
                urlString = task.getUrl();
            }
        } else if (selectedObject instanceof AbstractTaskContainer) {
            AbstractTaskContainer query = (AbstractTaskContainer)selectedObject;
            urlString = query.getUrl();
        }
        if (urlString != null) {
            TasksUiUtil.openUrl(urlString, false);
        }
    }
}

