/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class NewCategoryAction
extends Action
implements IViewActionDelegate {
    public static final String ID = "org.eclipse.mylyn.tasks.ui.actions.create.category";
    protected TaskCategory cat = null;

    public NewCategoryAction() {
        this.setText("New Category...");
        this.setToolTipText("New Category...");
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.CATEGORY_NEW);
    }

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Enter name", "Enter a name for the Category: ", "", null);
        int dialogResult = dialog.open();
        if (dialogResult == 0) {
            String name = dialog.getValue();
            Set queries = TasksUiPlugin.getTaskListManager().getTaskList().getQueries();
            Set categories = TasksUiPlugin.getTaskListManager().getTaskList().getCategories();
            for (AbstractTaskCategory category : categories) {
                if (name == null || !name.equals(category.getSummary())) continue;
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"New Category", (String)"A category with this name already exists, please choose another name.");
                return;
            }
            for (AbstractRepositoryQuery query : queries) {
                if (name == null || !name.equals(query.getSummary())) continue;
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"New Category", (String)"A query with this name already exists, please choose another name.");
                return;
            }
            this.cat = new TaskCategory(name);
            TasksUiPlugin.getTaskListManager().getTaskList().addCategory(this.cat);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

