/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractAttachmentHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class DownloadAttachmentJob
extends Job {
    private final RepositoryAttachment attachment;
    private final File targetFile;

    public DownloadAttachmentJob(RepositoryAttachment attachment, File targetFile) {
        super("Downloading Attachment");
        if (attachment == null) {
            throw new IllegalArgumentException("attachment must not be null");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        this.attachment = attachment;
        this.targetFile = targetFile;
    }

    protected IStatus run(IProgressMonitor monitor) {
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(this.attachment.getRepositoryKind(), this.attachment.getRepositoryUrl());
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.attachment.getRepositoryKind());
        AbstractAttachmentHandler handler = connector.getAttachmentHandler();
        if (handler == null) {
            return new RepositoryStatus(repository, 1, "org.eclipse.mylyn.tasks.ui", 7, "The repository does not support attachments.");
        }
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(this.targetFile);
                handler.downloadAttachment(repository, this.attachment, (OutputStream)out, monitor);
            }
            catch (CoreException e) {
                StatusHandler.displayStatus((String)"Download Attachment", (IStatus)e.getStatus());
                IStatus iStatus = Status.OK_STATUS;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not close attachment file: " + this.targetFile.getAbsolutePath(), (Throwable)e2));
                    }
                }
                return iStatus;
            }
            catch (IOException e) {
                RepositoryStatus repositoryStatus;
                block19: {
                    repositoryStatus = new RepositoryStatus(repository, 2, "org.eclipse.mylyn.tasks.ui", 5, "Error while writing to attachment file.", (Throwable)e);
                    if (out == null) break block19;
                    try {
                        out.close();
                    }
                    catch (IOException e3) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not close attachment file: " + this.targetFile.getAbsolutePath(), (Throwable)e3));
                    }
                }
                return repositoryStatus;
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not close attachment file: " + this.targetFile.getAbsolutePath(), (Throwable)e));
                }
            }
        }
        return Status.OK_STATUS;
    }
}

