/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.TaskRepositoryUtil;
import org.eclipse.mylyn.internal.tasks.ui.actions.AbstractTaskRepositoryAction;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;

public class DeleteTaskRepositoryAction
extends AbstractTaskRepositoryAction {
    private static final String ID = "org.eclipse.mylyn.tasklist.repositories.delete";

    public DeleteTaskRepositoryAction() {
        super("Delete Repository");
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_DELETE"));
        this.setId(ID);
        this.setEnabled(false);
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void init(IViewPart view) {
    }

    public void run() {
        try {
            boolean deleteConfirmed = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Confirm Delete", (String)"Delete the selected task repositories?");
            if (deleteConfirmed) {
                IStructuredSelection selection = this.getStructuredSelection();
                Set queries = TasksUiPlugin.getTaskListManager().getTaskList().getQueries();
                ArrayList<TaskRepository> repositoriesInUse = new ArrayList<TaskRepository>();
                ArrayList<TaskRepository> repositoriesToDelete = new ArrayList<TaskRepository>();
                for (Object selectedObject : selection.toList()) {
                    if (!(selectedObject instanceof TaskRepository)) continue;
                    TaskRepository taskRepository = (TaskRepository)selectedObject;
                    if (queries != null && queries.size() > 0) {
                        for (AbstractRepositoryQuery query : queries) {
                            if (!query.getRepositoryUrl().equals(taskRepository.getUrl())) continue;
                            repositoriesInUse.add(taskRepository);
                            break;
                        }
                    }
                    if (repositoriesInUse.contains(taskRepository)) continue;
                    repositoriesToDelete.add(taskRepository);
                }
                for (TaskRepository taskRepository : repositoriesToDelete) {
                    TasksUiPlugin.getRepositoryManager().removeRepository(taskRepository, TasksUiPlugin.getDefault().getRepositoriesFilePath());
                    TaskRepositoryUtil.disableAddAutomatically(taskRepository.getUrl());
                }
                if (repositoriesInUse.size() > 0) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Repository In Use", (String)"One or more of the selected repositories is being used by a query and can not be deleted.");
                }
            }
        }
        catch (Exception e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", e.getMessage(), (Throwable)e));
        }
    }
}

