/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearOutgoingAction
extends Action {
    private static final String ACTION_NAME = "Clear outgoing";
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.mark.discard";
    private List<AbstractTaskContainer> selectedElements;

    public ClearOutgoingAction(List<AbstractTaskContainer> selectedElements) {
        this.selectedElements = selectedElements;
        this.setText(ACTION_NAME);
        this.setToolTipText(ACTION_NAME);
        this.setImageDescriptor(TasksUiImages.CLEAR);
        this.setId(ID);
        if (selectedElements.size() == 1 && selectedElements.get(0) instanceof AbstractTask) {
            AbstractTask task = (AbstractTask)selectedElements.get(0);
            this.setEnabled(this.hasOutgoingChanges(task));
        } else {
            this.setEnabled(false);
        }
    }

    private boolean hasOutgoingChanges(AbstractTask task) {
        return task.getSynchronizationState().equals((Object)AbstractTask.RepositoryTaskSyncState.OUTGOING) || task.getSynchronizationState().equals((Object)AbstractTask.RepositoryTaskSyncState.CONFLICT);
    }

    public void run() {
        boolean confirm;
        ArrayList<AbstractTask> toClear = new ArrayList<AbstractTask>();
        for (AbstractTaskContainer selectedObject : this.selectedElements) {
            if (!(selectedObject instanceof AbstractTask) || !this.hasOutgoingChanges((AbstractTask)selectedObject)) continue;
            toClear.add((AbstractTask)selectedObject);
        }
        if (toClear.size() > 0 && (confirm = MessageDialog.openConfirm(null, (String)"Confirm discard", (String)("Discard all outgoing changes?\n\n" + ((AbstractTask)toClear.get(0)).getSummary())))) {
            TasksUiPlugin.getSynchronizationManager().discardOutgoing((AbstractTask)toClear.get(0));
        }
    }
}

