/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class AddRepositoryAction
extends Action {
    private static final String PREF_ADD_QUERY = "org.eclipse.mylyn.internal.tasks.add.query";
    public static final String TITLE = "Add Task Repository";
    private static final String ID = "org.eclipse.mylyn.tasklist.repositories.add";
    private boolean promptToAddQuery = true;

    public AddRepositoryAction() {
        this.setImageDescriptor(TasksUiImages.REPOSITORY_NEW);
        this.setText(TITLE);
        this.setId(ID);
        this.setEnabled(TasksUiPlugin.getRepositoryManager().hasUserManagedRepositoryConnectors());
    }

    public boolean getPromptToAddQuery() {
        return this.promptToAddQuery;
    }

    public void setPromptToAddQuery(boolean promptToAddQuery) {
        this.promptToAddQuery = promptToAddQuery;
    }

    public void run() {
        this.showWizard();
    }

    public TaskRepository showWizard() {
        IHandlerService handlerSvc = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            Object result = handlerSvc.executeCommand("org.eclipse.mylyn.tasks.ui.command.addTaskRepository", null);
            if (result instanceof TaskRepository) {
                if (this.getPromptToAddQuery()) {
                    this.promptToAddQuery((TaskRepository)result);
                }
                return (TaskRepository)result;
            }
        }
        catch (Exception e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", e.getMessage(), (Throwable)e));
        }
        return null;
    }

    public void promptToAddQuery(TaskRepository taskRepository) {
        IPreferenceStore preferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
        if (!preferenceStore.getBoolean(PREF_ADD_QUERY)) {
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            MessageDialogWithToggle messageDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)"Add new query", (String)"Would you like to add a query to the Task List for this repository?", (String)"Do not show again", (boolean)false, (IPreferenceStore)preferenceStore, (String)PREF_ADD_QUERY);
            preferenceStore.setValue(PREF_ADD_QUERY, messageDialog.getToggleState());
            if (messageDialog.getReturnCode() == 2) {
                AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(taskRepository.getConnectorKind());
                IWizard queryWizard = connectorUi.getQueryWizard(taskRepository, null);
                ((Wizard)queryWizard).setForcePreviousAndNextButtons(true);
                WizardDialog queryDialog = new WizardDialog(shell, queryWizard);
                queryDialog.create();
                queryDialog.setTitle("Add Repository Query");
                queryDialog.setBlockOnOpen(true);
                queryDialog.open();
            }
        }
    }
}

