/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.ActivateTaskDialogAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskNavigateDropDownAction;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskActivationHistory;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class ActivateTaskHistoryDropDownAction
extends TaskNavigateDropDownAction
implements IWorkbenchWindowPulldownDelegate,
ITaskActivityListener {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.navigate.previous";
    private boolean scopeToWorkingSet = false;
    private static final String LABEL = "Activate Previous Task";

    public ActivateTaskHistoryDropDownAction() {
        this(TasksUiPlugin.getTaskListManager().getTaskActivationHistory(), false);
    }

    public ActivateTaskHistoryDropDownAction(TaskActivationHistory history, boolean scopeToWorkingSet) {
        super(history);
        this.setText(LABEL);
        this.setToolTipText(LABEL);
        this.setId(ID);
        this.setEnabled(true);
        this.setImageDescriptor(TasksUiImages.NAVIGATE_PREVIOUS);
        this.scopeToWorkingSet = scopeToWorkingSet;
        TasksUiPlugin.getTaskListManager().addActivityListener(this);
    }

    public void dispose() {
        super.dispose();
        TasksUiPlugin.getTaskListManager().addActivityListener(this);
    }

    protected void addActionsToMenu() {
        ActionContributionItem item;
        List<Object> tasks = new ArrayList<AbstractTask>(this.taskHistory.getPreviousTasks());
        Set<IWorkingSet> sets = TaskListView.getActiveWorkingSets();
        if (this.scopeToWorkingSet && !sets.isEmpty()) {
            HashSet allWorkingSetTasks = new HashSet();
            for (IWorkingSet workingSet : sets) {
                Object elements;
                Object object = elements = workingSet.getElements();
                int n = ((Object)object).length;
                int n2 = 0;
                while (n2 < n) {
                    Object adaptable = object[n2];
                    if (adaptable instanceof AbstractTaskContainer) {
                        allWorkingSetTasks.addAll(((AbstractTaskContainer)adaptable).getChildren());
                    }
                    ++n2;
                }
            }
            ArrayList<Object> allScopedTasks = new ArrayList<Object>(tasks);
            for (AbstractTask abstractTask : tasks) {
                if (allWorkingSetTasks.contains(abstractTask)) continue;
                allScopedTasks.remove(abstractTask);
            }
            tasks = allScopedTasks;
        }
        if (tasks.size() > 12) {
            tasks = tasks.subList(tasks.size() - 12, tasks.size());
        }
        int i = tasks.size() - 1;
        while (i >= 0) {
            AbstractTask currTask = (AbstractTask)tasks.get(i);
            TaskNavigateDropDownAction.TaskNavigateAction taskNavigateAction = new TaskNavigateDropDownAction.TaskNavigateAction(this, currTask);
            item = new ActionContributionItem((IAction)taskNavigateAction);
            if (currTask.isActive()) {
                taskNavigateAction.setChecked(true);
            }
            item.fill(this.dropDownMenu, -1);
            --i;
        }
        Separator separator = new Separator();
        separator.fill(this.dropDownMenu, -1);
        AbstractTask active = TasksUiPlugin.getTaskListManager().getTaskList().getActiveTask();
        if (active != null) {
            DeactivateTaskAction deactivateTaskAction = new DeactivateTaskAction();
            item = new ActionContributionItem((IAction)deactivateTaskAction);
            item.fill(this.dropDownMenu, -1);
        } else {
            ActivateDialogAction activateDialogAction = new ActivateDialogAction(new ActivateTaskDialogAction());
            item = new ActionContributionItem((IAction)activateDialogAction);
            item.fill(this.dropDownMenu, -1);
        }
    }

    public void run() {
        if (this.taskHistory.hasPrevious()) {
            AbstractTask previousTask = this.taskHistory.getPreviousTask();
            if (previousTask != null && !previousTask.isActive()) {
                TasksUiPlugin.getTaskListManager().activateTask(previousTask, false);
                if (TaskListView.getFromActivePerspective() != null) {
                    TaskListView.getFromActivePerspective().refresh();
                }
            }
            this.setButtonStatus();
        }
    }

    public void taskActivated(AbstractTask task) {
    }

    public void taskDeactivated(AbstractTask task) {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void activityChanged(ScheduledTaskContainer week) {
    }

    public void calendarChanged() {
    }

    public void taskListRead() {
    }

    public class ActivateDialogAction
    extends Action {
        private ActivateTaskDialogAction dialogAction;

        public ActivateDialogAction(ActivateTaskDialogAction action) {
            this.dialogAction = action;
            this.dialogAction.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            this.setText("Activate Task...");
            this.setToolTipText("Activate Task...");
            this.setEnabled(true);
            this.setChecked(false);
            this.setImageDescriptor(null);
        }

        public void run() {
            this.dialogAction.run(null);
        }
    }

    public class DeactivateTaskAction
    extends Action {
        public DeactivateTaskAction() {
            this.setText("Deactivate Task");
            this.setToolTipText("Deactivate Task");
            this.setEnabled(true);
            this.setChecked(false);
            this.setImageDescriptor(null);
        }

        public void run() {
            AbstractTask active = TasksUiPlugin.getTaskListManager().getTaskList().getActiveTask();
            if (active != null) {
                TasksUiPlugin.getTaskListManager().deactivateTask(active);
            }
        }
    }
}

