/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public abstract class AbstractTaskRepositoryAction
extends BaseSelectionListenerAction {
    public AbstractTaskRepositoryAction(String text) {
        super(text);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            return this.getTaskRepository(selection.getFirstElement()) != null;
        }
        return false;
    }

    protected TaskRepository getTaskRepository(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            return this.getTaskRepository(selection.getFirstElement());
        }
        return null;
    }

    protected TaskRepository getTaskRepository(Object selectedObject) {
        TaskRepository taskRepository = null;
        if (selectedObject instanceof TaskRepository) {
            taskRepository = (TaskRepository)selectedObject;
        } else if (selectedObject instanceof AbstractRepositoryQuery) {
            AbstractRepositoryQuery query = (AbstractRepositoryQuery)selectedObject;
            taskRepository = TasksUiPlugin.getRepositoryManager().getRepository(query.getRepositoryKind(), query.getRepositoryUrl());
        }
        if (taskRepository != null && this.isUserManaged(taskRepository)) {
            return taskRepository;
        }
        return null;
    }

    protected boolean isUserManaged(TaskRepository taskRepository) {
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(taskRepository.getConnectorKind());
        return connector != null && connector.isUserManaged();
    }
}

