/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.IActionFilter;

public class TaskRepositoryAdapterFactory
implements IAdapterFactory {
    private static final Class[] ADAPTER_TYPES = new Class[]{IActionFilter.class};

    public Class[] getAdapterList() {
        return ADAPTER_TYPES;
    }

    public Object getAdapter(Object adaptable, Class adapterType) {
        if (adaptable instanceof TaskRepository) {
            return new IActionFilter(){

                public boolean testAttribute(Object target, String name, String value) {
                    TaskRepository repository = (TaskRepository)target;
                    if ("offline".equals(name)) {
                        return Boolean.valueOf(value).booleanValue() == repository.isOffline();
                    }
                    if ("supportQuery".equals(name)) {
                        AbstractRepositoryConnectorUi connector = TasksUiPlugin.getConnectorUi(repository.getConnectorKind());
                        return connector.getQueryWizard(repository, null) != null;
                    }
                    if ("supportNewTask".equals(name)) {
                        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
                        return connector.canCreateNewTask(repository);
                    }
                    if ("hasRepository".equals(name)) {
                        return !repository.getConnectorKind().equals("local");
                    }
                    return false;
                }
            };
        }
        return null;
    }
}

