/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskDataExportJob;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskDataExportWizard;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class TaskListBackupManager
implements IPropertyChangeListener {
    private static final String TITLE_TASKLIST_BACKUP = "Tasklist Backup";
    private static final String BACKUP_JOB_NAME = "Scheduled task data backup";
    public static final String BACKUP_FAILURE_MESSAGE = "Could not backup task data. Check backup preferences.\n";
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private Timer timer;

    public TaskListBackupManager() {
        int days = TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.backup.schedule");
        if (days > 0) {
            this.start(120000L);
        }
    }

    public void start(long delay) {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new CheckBackupRequired(), delay, 3600000L);
    }

    public void stop() {
        this.timer.cancel();
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void backupNow(boolean synchronous) {
        String destination = TasksUiPlugin.getDefault().getBackupFolderPath();
        File backupFolder = new File(destination);
        if (!backupFolder.exists()) {
            backupFolder.mkdir();
        }
        this.removeOldBackups(backupFolder);
        String fileName = TaskDataExportWizard.getZipFileName();
        if (!synchronous) {
            ExportJob export = new ExportJob(destination, fileName);
            export.schedule();
        } else {
            TaskDataExportJob backupJob = new TaskDataExportJob(destination, true, fileName);
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            try {
                service.run(true, false, (IRunnableWithProgress)backupJob);
                TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.backup.last", new Date().getTime());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                MessageDialog.openError(null, (String)TITLE_TASKLIST_BACKUP, (String)BACKUP_FAILURE_MESSAGE);
            }
        }
    }

    public void removeOldBackups(File folder) {
        int maxBackups = TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.backup.maxfiles");
        File[] files = folder.listFiles();
        ArrayList<File> backupFiles = new ArrayList<File>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith("mylyndata")) {
                backupFiles.add(file);
            }
            ++n2;
        }
        File[] backupFileArray = backupFiles.toArray(new File[backupFiles.size()]);
        if (backupFileArray != null && backupFileArray.length > 0) {
            Arrays.sort(backupFileArray, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    return new Long(file1.lastModified()).compareTo(new Long(file2.lastModified()));
                }
            });
            int toomany = backupFileArray.length - maxBackups;
            if (toomany > 0) {
                int x = 0;
                while (x < toomany) {
                    if (backupFileArray[x] != null) {
                        backupFileArray[x].delete();
                    }
                    ++x;
                }
            }
        }
    }

    class CheckBackupRequired
    extends TimerTask {
        CheckBackupRequired() {
        }

        public void run() {
            if (!Platform.isRunning() || TasksUiPlugin.getDefault() == null) {
                return;
            }
            long lastBackup = TasksUiPlugin.getDefault().getPreferenceStore().getLong("org.eclipse.mylyn.tasks.ui.backup.last");
            int days = TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.backup.schedule");
            long waitPeriod = (long)days * 86400000L;
            long now = new Date().getTime();
            if (now - lastBackup > waitPeriod) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TaskListBackupManager.this.backupNow(false);
                    }
                });
            }
        }
    }

    static class ExportJob
    extends Job {
        final TaskDataExportJob backupJob;

        public ExportJob(String destination, String filename) {
            super(TaskListBackupManager.BACKUP_JOB_NAME);
            this.backupJob = new TaskDataExportJob(destination, true, filename);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (Platform.isRunning()) {
                    this.backupJob.run(monitor);
                    TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.backup.last", new Date().getTime());
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                MessageDialog.openError(null, (String)TaskListBackupManager.BACKUP_JOB_NAME, (String)"Error occured during scheduled tasklist backup.\nCheck settings on Tasklist preferences page.");
            }
            catch (InterruptedException interruptedException) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

