/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.ActivateTaskDialogAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskActivationHistory;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskElementLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.services.IServiceLocator;

public class TaskHistoryDropDown
extends CompoundContributionItem {
    private static final int MAX_ITEMS_TO_DISPLAY = 12;
    private boolean scopeToWorkingSet = false;
    private TaskActivationHistory taskHistory;
    private TaskElementLabelProvider labelProvider = new TaskElementLabelProvider(false);

    public TaskHistoryDropDown() {
        this(null);
    }

    public TaskHistoryDropDown(String id) {
        super(id);
        this.taskHistory = TasksUiPlugin.getTaskListManager().getTaskActivationHistory();
    }

    protected IContributionItem[] getContributionItems() {
        ActionContributionItem item;
        List<Object> tasks = new ArrayList<AbstractTask>(this.taskHistory.getPreviousTasks());
        Set<IWorkingSet> sets = TaskListView.getActiveWorkingSets();
        if (this.scopeToWorkingSet && !sets.isEmpty()) {
            HashSet allWorkingSetTasks = new HashSet();
            for (IWorkingSet workingSet : sets) {
                Object elements;
                Object object = elements = workingSet.getElements();
                int n = ((Object)object).length;
                int n2 = 0;
                while (n2 < n) {
                    Object adaptable = object[n2];
                    if (adaptable instanceof AbstractTaskContainer) {
                        allWorkingSetTasks.addAll(((AbstractTaskContainer)adaptable).getChildren());
                    }
                    ++n2;
                }
            }
            ArrayList<AbstractTask> allScopedTasks = new ArrayList<AbstractTask>(tasks);
            for (AbstractTask abstractTask : tasks) {
                if (allWorkingSetTasks.contains(abstractTask)) continue;
                allScopedTasks.remove(abstractTask);
            }
            tasks = allScopedTasks;
        }
        if (tasks.size() > 12) {
            tasks = tasks.subList(tasks.size() - 12, tasks.size());
        }
        ArrayList<Object> items = new ArrayList<Object>();
        int i = tasks.size() - 1;
        while (i >= 0) {
            AbstractTask abstractTask = (AbstractTask)tasks.get(i);
            TaskNavigateAction taskNavAction = new TaskNavigateAction(abstractTask);
            item = new ActionContributionItem((IAction)taskNavAction);
            if (abstractTask.isActive()) {
                taskNavAction.setChecked(true);
            }
            items.add(item);
            --i;
        }
        Separator separator = new Separator();
        items.add(separator);
        AbstractTask abstractTask = TasksUiPlugin.getTaskListManager().getTaskList().getActiveTask();
        if (abstractTask != null) {
            CommandContributionItem pauseContributionItem = new CommandContributionItem((IServiceLocator)PlatformUI.getWorkbench(), "org.eclipse.mylyn.ui.context.capture.pause", "org.eclipse.mylyn.ui.context.capture.pause.command", Collections.EMPTY_MAP, TasksUiImages.CAPTURE_PAUSE, null, null, "Pause Capturing Context", null, "Pause Capturing Context", 32);
            items.add(pauseContributionItem);
            DeactivateTaskAction deactivateAction = new DeactivateTaskAction();
            ActionContributionItem item2 = new ActionContributionItem((IAction)deactivateAction);
            items.add(item2);
        } else {
            ActivateDialogAction activateDialogAction = new ActivateDialogAction(new ActivateTaskDialogAction());
            item = new ActionContributionItem((IAction)activateDialogAction);
            items.add(item);
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    public class ActivateDialogAction
    extends Action {
        private ActivateTaskDialogAction dialogAction;

        public ActivateDialogAction(ActivateTaskDialogAction action) {
            this.dialogAction = action;
            this.dialogAction.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            this.setText("Activate Task...");
            this.setToolTipText("Activate Task...");
            this.setEnabled(true);
            this.setChecked(false);
            this.setImageDescriptor(null);
        }

        public void run() {
            this.dialogAction.run(null);
        }
    }

    public class DeactivateTaskAction
    extends Action {
        public DeactivateTaskAction() {
            this.setText("Deactivate Task");
            this.setToolTipText("Deactivate Task");
            this.setEnabled(true);
            this.setChecked(false);
            this.setImageDescriptor(null);
        }

        public void run() {
            AbstractTask active = TasksUiPlugin.getTaskListManager().getTaskList().getActiveTask();
            if (active != null) {
                TasksUiPlugin.getTaskListManager().deactivateTask(active);
            }
        }
    }

    public class TaskNavigateAction
    extends Action {
        private static final int MAX_LABEL_LENGTH = 40;
        private AbstractTask targetTask;

        public TaskNavigateAction(AbstractTask task) {
            this.targetTask = task;
            String taskDescription = task.getSummary();
            if (taskDescription.length() > 40) {
                taskDescription = taskDescription.subSequence(0, 37) + "...";
            }
            this.setText(taskDescription);
            this.setEnabled(true);
            this.setToolTipText(task.getSummary());
            Image image = TaskHistoryDropDown.this.labelProvider.getImage(task);
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
        }

        public void run() {
            if (this.targetTask.isActive()) {
                return;
            }
            new TaskActivateAction().run(this.targetTask);
        }
    }
}

