/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.planner.DateSelectionDialog;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TaskListManager;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleTaskMenuContributor
implements IDynamicSubMenuContributor {
    private static final String LABEL_THIS_WEEK = "This week";
    private static final String LABEL_REMINDER = "Schedule for";
    private static final String LABEL_TODAY = "Today";
    private static final String LABEL_NEXT_WEEK = "Next Week";
    private static final String LABEL_TWO_WEEKS = "Two Weeks";
    private static final String LABEL_FUTURE = "Future";
    private static final String LABEL_CALENDAR = "Choose Date...";
    private static final String LABEL_NOT_SCHEDULED = "Not Scheduled";

    @Override
    public MenuManager getSubMenuManager(List<AbstractTaskContainer> selectedElements) {
        AbstractTaskContainer selectedElement;
        final TaskListManager tasklistManager = TasksUiPlugin.getTaskListManager();
        MenuManager subMenuManager = new MenuManager(LABEL_REMINDER);
        subMenuManager.setVisible(selectedElements.size() > 0 && selectedElements.get(0) instanceof AbstractTask);
        AbstractTaskContainer singleSelection = null;
        if (selectedElements.size() == 1 && (selectedElement = selectedElements.get(0)) instanceof AbstractTask) {
            singleSelection = selectedElement;
        }
        final AbstractTask singleTaskSelection = tasklistManager.getTaskForElement(singleSelection, false);
        final ArrayList<AbstractTaskContainer> taskListElementsToSchedule = new ArrayList<AbstractTaskContainer>();
        for (AbstractTaskContainer selectedElement2 : selectedElements) {
            if (!(selectedElement2 instanceof AbstractTask)) continue;
            taskListElementsToSchedule.add(selectedElement2);
        }
        Action action = new Action(){

            public void run() {
                Calendar reminderCalendar = GregorianCalendar.getInstance();
                TaskActivityUtil.snapEndOfWorkDay((Calendar)reminderCalendar);
                for (AbstractTaskContainer element : taskListElementsToSchedule) {
                    AbstractTask task = tasklistManager.getTaskForElement(element, true);
                    ScheduleTaskMenuContributor.this.setScheduledDate(task, reminderCalendar, false);
                }
            }
        };
        action.setText(LABEL_TODAY);
        action.setImageDescriptor(TasksUiImages.SCHEDULE_DAY);
        action.setEnabled(this.canSchedule(singleSelection, taskListElementsToSchedule));
        subMenuManager.add((IAction)action);
        if (singleTaskSelection != null && (TasksUiPlugin.getTaskActivityManager().isScheduledForToday(this.getScheduledForDate(singleTaskSelection), this.isFloating(singleTaskSelection)) || this.isPastReminder(singleTaskSelection) && !this.isFloating(singleTaskSelection))) {
            action.setChecked(true);
        }
        final int today = Calendar.getInstance().get(7);
        int i = today + 1;
        while (i <= today + 7) {
            final int day = i;
            action = new Action(){

                public void run() {
                    Calendar reminderCalendar = TaskActivityUtil.getCalendar();
                    int dueIn = day - today;
                    TasksUiPlugin.getTaskListManager().setSecheduledIn(reminderCalendar, dueIn);
                    for (AbstractTaskContainer element : taskListElementsToSchedule) {
                        AbstractTask task = tasklistManager.getTaskForElement(element, true);
                        ScheduleTaskMenuContributor.this.setScheduledDate(task, reminderCalendar, false);
                    }
                }
            };
            this.getDayLabel(i, action);
            if (singleTaskSelection != null && this.getScheduledForDate(singleTaskSelection) != null && !this.isFloating(singleTaskSelection)) {
                Calendar dayStart = Calendar.getInstance();
                dayStart.add(5, i - today);
                TaskActivityUtil.snapStartOfDay((Calendar)dayStart);
                dayStart.getTime();
                Calendar dayEnd = Calendar.getInstance();
                dayEnd.add(5, i - today);
                TaskActivityUtil.snapEndOfDay((Calendar)dayEnd);
                dayEnd.getTime();
                Calendar time = TaskActivityUtil.getCalendar();
                time.setTime(this.getScheduledForDate(singleTaskSelection));
                if (TaskActivityUtil.isBetween((Calendar)time, (Calendar)dayStart, (Calendar)dayEnd)) {
                    action.setChecked(true);
                }
            }
            action.setEnabled(this.canSchedule(singleSelection, taskListElementsToSchedule));
            subMenuManager.add((IAction)action);
            ++i;
        }
        subMenuManager.add((IContributionItem)new Separator());
        action = new Action(){

            public void run() {
                Calendar reminderCalendar = TaskActivityUtil.getCalendar();
                TaskActivityUtil.snapStartOfWorkWeek((Calendar)reminderCalendar);
                for (AbstractTaskContainer element : taskListElementsToSchedule) {
                    AbstractTask task = tasklistManager.getTaskForElement(element, true);
                    if (task == null) continue;
                    ScheduleTaskMenuContributor.this.setScheduledDate(task, reminderCalendar, true);
                }
            }
        };
        action.setText(LABEL_THIS_WEEK);
        action.setImageDescriptor(TasksUiImages.SCHEDULE_WEEK);
        action.setEnabled(this.canSchedule(singleSelection, taskListElementsToSchedule));
        subMenuManager.add((IAction)action);
        if (singleTaskSelection != null && this.isFloating(singleTaskSelection) && (TasksUiPlugin.getTaskActivityManager().isScheduledForThisWeek(this.getScheduledForDate(singleTaskSelection)) || this.isPastReminder(singleTaskSelection))) {
            action.setChecked(true);
        }
        action = new Action(){

            public void run() {
                for (AbstractTaskContainer element : taskListElementsToSchedule) {
                    AbstractTask task = tasklistManager.getTaskForElement(element, true);
                    Calendar startNextWeek = Calendar.getInstance();
                    TaskActivityUtil.snapNextWorkWeek((Calendar)startNextWeek);
                    ScheduleTaskMenuContributor.this.setScheduledDate(task, startNextWeek, true);
                }
            }
        };
        action.setText(LABEL_NEXT_WEEK);
        action.setEnabled(this.canSchedule(singleSelection, taskListElementsToSchedule));
        if (singleTaskSelection != null && this.isFloating(singleTaskSelection) && TasksUiPlugin.getTaskActivityManager().isScheduledAfterThisWeek(this.getScheduledForDate(singleTaskSelection)) && !TasksUiPlugin.getTaskActivityManager().isScheduledForFuture(this.getScheduledForDate(singleTaskSelection))) {
            action.setChecked(true);
        }
        subMenuManager.add((IAction)action);
        action = new Action(){

            public void run() {
                for (AbstractTaskContainer element : taskListElementsToSchedule) {
                    AbstractTask task = tasklistManager.getTaskForElement(element, true);
                    if (task == null) continue;
                    Calendar twoWeeks = TaskActivityUtil.getCalendar();
                    TaskActivityUtil.snapNextWorkWeek((Calendar)twoWeeks);
                    twoWeeks.add(5, 7);
                    ScheduleTaskMenuContributor.this.setScheduledDate(task, twoWeeks, true);
                }
            }
        };
        action.setText(LABEL_TWO_WEEKS);
        action.setEnabled(this.canSchedule(singleSelection, taskListElementsToSchedule));
        if (singleTaskSelection != null && this.getScheduledForDate(singleTaskSelection) != null && this.isFloating(singleTaskSelection)) {
            Calendar time = TaskActivityUtil.getCalendar();
            time.setTime(this.getScheduledForDate(singleTaskSelection));
            Calendar start = TaskActivityUtil.getCalendar();
            start.setTime(TasksUiPlugin.getTaskActivityManager().getActivityFuture().getStart().getTime());
            Calendar end = TaskActivityUtil.getCalendar();
            end.setTime(TasksUiPlugin.getTaskActivityManager().getActivityFuture().getStart().getTime());
            TaskActivityUtil.snapEndOfWeek((Calendar)end);
            if (TaskActivityUtil.isBetween((Calendar)time, (Calendar)start, (Calendar)end)) {
                action.setChecked(true);
            }
        }
        subMenuManager.add((IAction)action);
        if (singleTaskSelection != null && this.getScheduledForDate(singleTaskSelection) != null) {
            Calendar time = TaskActivityUtil.getCalendar();
            time.setTime(this.getScheduledForDate(singleTaskSelection));
            Calendar start = TaskActivityUtil.getCalendar();
            start.setTime(TasksUiPlugin.getTaskActivityManager().getActivityFuture().getStart().getTime());
            start.add(4, 1);
            if (time.compareTo(start) >= 0) {
                action = new Action(){

                    public void run() {
                    }
                };
                action.setChecked(true);
                action.setText(LABEL_FUTURE);
                subMenuManager.add((IAction)action);
            }
        }
        subMenuManager.add((IContributionItem)new Separator());
        action = new Action(){

            public void run() {
                DateSelectionDialog reminderDialog;
                int result;
                Calendar theCalendar = GregorianCalendar.getInstance();
                if (singleTaskSelection != null && ScheduleTaskMenuContributor.this.getScheduledForDate(singleTaskSelection) != null) {
                    theCalendar.setTime(ScheduleTaskMenuContributor.this.getScheduledForDate(singleTaskSelection));
                }
                if ((result = (reminderDialog = new DateSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), theCalendar, "Choose Date", false)).open()) == 0) {
                    for (AbstractTaskContainer element : taskListElementsToSchedule) {
                        AbstractTask task = null;
                        if (!(element instanceof AbstractTask)) continue;
                        task = (AbstractTask)element;
                        if (reminderDialog.getDate() != null) {
                            Calendar cal = TaskActivityUtil.getCalendar();
                            cal.setTime(reminderDialog.getDate());
                            ScheduleTaskMenuContributor.this.setScheduledDate(task, cal, false);
                            continue;
                        }
                        ScheduleTaskMenuContributor.this.setScheduledDate(task, null, false);
                    }
                }
            }
        };
        action.setText(LABEL_CALENDAR);
        action.setEnabled(this.canSchedule(singleSelection, taskListElementsToSchedule));
        subMenuManager.add((IAction)action);
        action = new Action(){

            public void run() {
                for (AbstractTaskContainer element : taskListElementsToSchedule) {
                    AbstractTask task = tasklistManager.getTaskForElement(element, true);
                    ScheduleTaskMenuContributor.this.setScheduledDate(task, null, false);
                }
            }
        };
        action.setText(LABEL_NOT_SCHEDULED);
        if (singleTaskSelection != null && this.getScheduledForDate(singleTaskSelection) == null) {
            action.setChecked(true);
        }
        subMenuManager.add((IAction)action);
        return subMenuManager;
    }

    private void getDayLabel(int i, Action action) {
        if (i > 8) {
            i -= 7;
        }
        switch (i) {
            case 2: {
                action.setText("Monday");
                break;
            }
            case 3: {
                action.setText("Tuesday");
                break;
            }
            case 4: {
                action.setText("Wednesday");
                break;
            }
            case 5: {
                action.setText("Thursday");
                break;
            }
            case 6: {
                action.setText("Friday");
                break;
            }
            case 7: {
                action.setText("Saturday");
                break;
            }
            case 8: {
                action.setText("Sunday");
                break;
            }
        }
    }

    private boolean canSchedule(AbstractTaskContainer singleSelection, List<AbstractTaskContainer> elements) {
        if (singleSelection instanceof AbstractTask) {
            return !((AbstractTask)singleSelection).isCompleted() || elements.size() > 0;
        }
        return elements.size() > 0;
    }

    protected void setScheduledDate(AbstractTask task, Calendar scheduledDate, boolean floating) {
        if (task != null) {
            if (scheduledDate != null) {
                TasksUiPlugin.getTaskActivityManager().setScheduledFor(task, scheduledDate.getTime(), floating);
            } else {
                TasksUiPlugin.getTaskActivityManager().setScheduledFor(task, null, floating);
            }
        }
    }

    protected Date getScheduledForDate(AbstractTask singleTaskSelection) {
        return singleTaskSelection.getScheduledForDate();
    }

    protected boolean isFloating(AbstractTask task) {
        return task.internalIsFloatingScheduledDate();
    }

    private boolean isPastReminder(AbstractTask task) {
        Date date = this.getScheduledForDate(task);
        return TasksUiPlugin.getTaskActivityManager().isPastReminder(date, task.isCompleted());
    }
}

