/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.RepositoryTaskEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenRepositoryTaskJob
extends Job {
    private String serverUrl;
    private IWorkbenchPage page;
    private String repositoryKind;
    private String taskId;
    private String taskUrl;

    public OpenRepositoryTaskJob(String repositoryKind, String serverUrl, String taskId, String taskUrl, IWorkbenchPage page) {
        super("Opening repository task " + taskId);
        this.repositoryKind = repositoryKind;
        this.taskId = taskId;
        this.serverUrl = serverUrl;
        this.taskUrl = taskUrl;
        this.page = page;
    }

    public IStatus run(IProgressMonitor monitor) {
        block9: {
            monitor.beginTask("Opening Remote Task", 10);
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(this.repositoryKind, this.serverUrl);
            if (repository == null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError(null, (String)"Repository Not Found", (String)("Could not find repository configuration for " + OpenRepositoryTaskJob.this.serverUrl + ". \nPlease set up repository via " + "Task Repositories" + "."));
                        TasksUiUtil.openUrl(OpenRepositoryTaskJob.this.taskUrl, false);
                    }
                });
                return Status.OK_STATUS;
            }
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repositoryKind);
            try {
                try {
                    AbstractTaskDataHandler offlineHandler = connector.getTaskDataHandler();
                    if (offlineHandler != null) {
                        RepositoryTaskData downloadedTaskData = null;
                        downloadedTaskData = offlineHandler.getTaskData(repository, this.taskId, monitor);
                        if (downloadedTaskData != null) {
                            TasksUiPlugin.getTaskDataManager().setNewTaskData(downloadedTaskData);
                        }
                        this.openEditor(repository, downloadedTaskData);
                    } else {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                TasksUiUtil.openUrl(OpenRepositoryTaskJob.this.taskUrl, false);
                            }
                        });
                    }
                }
                catch (CoreException e) {
                    StatusHandler.displayStatus((String)"Unable to open task", (IStatus)e.getStatus());
                    monitor.done();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        return new Status(0, "org.eclipse.mylyn.tasks.ui", 0, "", null);
    }

    private void openEditor(final TaskRepository repository, final RepositoryTaskData taskData) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (taskData == null) {
                    TasksUiUtil.openUrl(OpenRepositoryTaskJob.this.taskUrl, false);
                } else {
                    RepositoryTaskEditorInput editorInput = new RepositoryTaskEditorInput(repository, taskData.getId(), OpenRepositoryTaskJob.this.taskUrl);
                    TasksUiUtil.openEditor(editorInput, "org.eclipse.mylyn.tasks.ui.editors.task", OpenRepositoryTaskJob.this.page);
                }
            }
        });
    }
}

