/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.monitor.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.PlatformActivator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.monitor.core.util.IStatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusHandler {
    private static final String ID_PLUGIN = "org.eclipse.mylyn";
    private static Set<IStatusHandler> handlers = new HashSet<IStatusHandler>();
    private static IStatusHandler defaultHandler;

    public static IStatusHandler getDefaultStatusHandler() {
        return defaultHandler;
    }

    public static Set<IStatusHandler> getStatusHandlers() {
        return handlers;
    }

    public static void setDefaultStatusHandler(IStatusHandler handler) {
        defaultHandler = handler;
        handlers.add(handler);
    }

    public static void addStatusHandler(IStatusHandler handler) {
        if (handler == null) {
            return;
        }
        if (handler != defaultHandler) {
            StatusHandler.internalRemoveStatusHandler(defaultHandler, false);
        }
        handlers.add(handler);
    }

    public static void removeStatusHandler(IStatusHandler handler) {
        StatusHandler.internalRemoveStatusHandler(handler, true);
    }

    private static void internalRemoveStatusHandler(IStatusHandler handler, boolean restoreDefault) {
        if (handler == null) {
            return;
        }
        handlers.remove(handler);
        if (restoreDefault && handlers.size() == 0) {
            StatusHandler.addStatusHandler(defaultHandler);
        }
    }

    public static void log(IStatus status) {
        ILog log;
        if (InternalPlatform.getDefault() != null && PlatformActivator.getContext() != null && (log = InternalPlatform.getDefault().getLog(PlatformActivator.getContext().getBundle())) != null) {
            log.log(status);
        }
    }

    public static void log(String message, Object source) {
        message = "Mylyn: " + message;
        if (source != null) {
            message = String.valueOf(message) + ", source: " + source.getClass().getName();
        }
        StatusHandler.log((IStatus)new Status(1, ID_PLUGIN, 0, message, null));
    }

    public static void log(Throwable throwable, String message) {
        StatusHandler.fail(throwable, message, false, 1);
    }

    public static void fail(Throwable throwable, String message, boolean informUser) {
        StatusHandler.fail(throwable, message, informUser, 4);
    }

    public static void fail(Throwable throwable, String message, boolean informUser, int severity) {
        if (message == null) {
            message = "no message";
        }
        message = String.valueOf(message) + "\n";
        Status status = new Status(severity, ID_PLUGIN, 0, message, throwable);
        for (IStatusHandler handler : handlers) {
            handler.fail((IStatus)status, informUser);
        }
        StatusHandler.log((IStatus)status);
    }

    public static void fail(IStatus status) {
        StatusHandler.log(status);
        for (IStatusHandler handler : handlers) {
            handler.fail(status, true);
        }
    }

    public static void displayStatus(String title, IStatus status) {
        for (IStatusHandler handler : handlers) {
            handler.displayStatus(title, status);
        }
    }
}

