/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.core.collection;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.internal.monitor.core.collection.IUsageCollector;
import org.eclipse.mylyn.internal.monitor.core.collection.InteractionEventClassifier;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataOverviewCollector
implements IUsageCollector {
    private static long FIVEMININMS = 300000L;
    private Map<Integer, Integer> interactionHistorySizes = new HashMap<Integer, Integer>();
    private Map<Integer, List<Date>> interactionHistoryRanges = new HashMap<Integer, List<Date>>();
    private Map<Integer, Long> interactionHistoryActiveDuration = new HashMap<Integer, Long>();
    private int currentUser = -1;
    private InteractionEvent lastUserEvent;
    private static int startDatePosition = 0;
    private static int endDatePosition = 1;
    private String filePrefix = "";

    public DataOverviewCollector(String prefix) {
        this.filePrefix = prefix;
    }

    @Override
    public String getReportTitle() {
        return "Data Overview";
    }

    @Override
    public void consumeEvent(InteractionEvent event, int userId) {
        long elapsed;
        List<Object> dateRange;
        if (!this.interactionHistorySizes.containsKey(userId)) {
            this.interactionHistorySizes.put(userId, 0);
        }
        this.interactionHistorySizes.put(userId, this.interactionHistorySizes.get(userId) + 1);
        if (!this.interactionHistoryRanges.containsKey(userId)) {
            dateRange = new ArrayList(2);
            this.interactionHistoryRanges.put(userId, dateRange);
        }
        if ((dateRange = this.interactionHistoryRanges.get(userId)).size() == 0) {
            dateRange.add(event.getDate());
        } else if (dateRange.size() == 1) {
            dateRange.add(event.getDate());
        } else {
            dateRange.set(endDatePosition, event.getDate());
        }
        if (this.currentUser == -1 || this.currentUser != userId) {
            this.lastUserEvent = event;
            this.currentUser = userId;
        }
        if ((elapsed = event.getDate().getTime() - this.lastUserEvent.getDate().getTime()) < FIVEMININMS) {
            if (!this.interactionHistoryActiveDuration.containsKey(userId)) {
                this.interactionHistoryActiveDuration.put(userId, new Long(0L));
            }
            this.interactionHistoryActiveDuration.put(userId, this.interactionHistoryActiveDuration.get(userId) + elapsed);
        }
        this.lastUserEvent = event;
    }

    @Override
    public List<String> getReport() {
        ArrayList<String> report = new ArrayList<String>();
        report.add("<h4>Data Overview</h4>");
        report.add("Number of Users: " + this.interactionHistorySizes.keySet().size() + "<br>");
        for (Map.Entry<Integer, Integer> entry : this.interactionHistorySizes.entrySet()) {
            report.add(entry.getKey() + ": " + entry.getValue() + " events; ");
            report.add(String.valueOf(InteractionEventClassifier.formatDuration(this.interactionHistoryActiveDuration.get(entry.getKey()))) + " active use; ");
            List<Date> dateRange = this.interactionHistoryRanges.get(entry.getKey());
            long duration = dateRange.get(endDatePosition).getTime() - dateRange.get(startDatePosition).getTime();
            report.add(dateRange.get(startDatePosition) + " to " + dateRange.get(endDatePosition) + ", a period of " + InteractionEventClassifier.formatDuration(duration) + " hours.");
            report.add("<br><br>");
        }
        return report;
    }

    @Override
    public void exportAsCSVFile(String directory) {
        String filename = String.valueOf(directory) + File.separator + this.filePrefix + "baseLine.csv";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(filename)));
            writer.write("User");
            writer.write(",");
            writer.write("Events");
            writer.write(",");
            writer.write("Start");
            writer.write(",");
            writer.write("End");
            writer.write(",");
            writer.write("Active Use");
            writer.write(",");
            writer.write("Elapsed Use");
            writer.newLine();
            for (Map.Entry<Integer, Integer> entry : this.interactionHistorySizes.entrySet()) {
                writer.write(entry.getKey().toString());
                writer.write(",");
                writer.write(entry.getValue().toString());
                writer.write(",");
                List<Date> dateRange = this.interactionHistoryRanges.get(entry.getKey());
                writer.write(dateRange.get(startDatePosition).toString());
                writer.write(",");
                writer.write(dateRange.get(endDatePosition).toString());
                writer.write(",");
                long elapsed = this.interactionHistoryActiveDuration.get(entry.getKey());
                writer.write(InteractionEventClassifier.formatDuration(elapsed));
                writer.write(",");
                long duration = dateRange.get(endDatePosition).getTime() - dateRange.get(startDatePosition).getTime();
                writer.write(InteractionEventClassifier.formatDuration(duration));
                writer.newLine();
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Unable to write CVS file <" + filename + ">");
            e.printStackTrace(System.err);
        }
    }

    public long getActiveUseOfUser(int userid) {
        if (this.interactionHistoryActiveDuration.containsKey(userid)) {
            return this.interactionHistoryActiveDuration.get(userid);
        }
        return -1L;
    }

    public int getNumberOfUsers() {
        return this.interactionHistorySizes.size();
    }

    public long getDurationUseOfUser(int userid) {
        if (this.interactionHistoryRanges.containsKey(userid)) {
            List<Date> dateRange = this.interactionHistoryRanges.get(userid);
            return dateRange.get(endDatePosition).getTime() - dateRange.get(startDatePosition).getTime();
        }
        return -1L;
    }

    public int getSizeOfHistory(int userid) {
        if (this.interactionHistorySizes.containsKey(userid)) {
            return this.interactionHistorySizes.get(userid);
        }
        return -1;
    }

    @Override
    public List<String> getPlainTextReport() {
        ArrayList<String> report = new ArrayList<String>();
        report.add("Data Overview");
        report.add("Number of Users: " + this.interactionHistorySizes.keySet().size());
        for (Map.Entry<Integer, Integer> entry : this.interactionHistorySizes.entrySet()) {
            report.add(entry.getKey() + ": " + entry.getValue() + " events; ");
            report.add(String.valueOf(InteractionEventClassifier.formatDuration(this.interactionHistoryActiveDuration.get(entry.getKey()))) + " active use; ");
            List<Date> dateRange = this.interactionHistoryRanges.get(entry.getKey());
            long duration = dateRange.get(endDatePosition).getTime() - dateRange.get(startDatePosition).getTime();
            report.add(dateRange.get(startDatePosition) + " to " + dateRange.get(endDatePosition) + ", a period of " + InteractionEventClassifier.formatDuration(duration) + " hours.");
        }
        return report;
    }
}

