/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionContextListener2;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.internal.context.core.CompositeContextElement;
import org.eclipse.mylyn.internal.context.core.CompositeInteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextElement;
import org.eclipse.mylyn.internal.context.core.InteractionContextExternalizer;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.LegacyActivityAdaptor;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionContextManager {
    private static final String PROPERTY_CONTEXT_ACTIVE = "org.eclipse.mylyn.context.core.context.active";
    private static final String PREFERENCE_ATTENTION_MIGRATED = "mylyn.attention.migrated";
    public static final String CONTEXT_FILENAME_ENCODING = "UTF-8";
    public static final String ACTIVITY_DELTA_DEACTIVATED = "deactivated";
    public static final String ACTIVITY_DELTA_ACTIVATED = "activated";
    public static final String ACTIVITY_DELTA_ADDED = "added";
    public static final String ACTIVITY_DELTA_STARTED = "started";
    public static final String ACTIVITY_DELTA_STOPPED = "stopped";
    public static final String ACTIVITY_ORIGINID_WORKBENCH = "org.eclipse.ui.workbench";
    public static final String ACTIVITY_ORIGINID_OS = "os";
    public static final String ACTIVITY_STRUCTUREKIND_LIFECYCLE = "lifecycle";
    public static final String ACTIVITY_STRUCTUREKIND_TIMING = "timing";
    public static final String ACTIVITY_STRUCTUREKIND_ACTIVATION = "activation";
    public static final String CONTEXT_HISTORY_FILE_NAME = "activity";
    public static final String OLD_CONTEXT_HISTORY_FILE_NAME = "context-history";
    public static final String SOURCE_ID_MODEL_PROPAGATION = "org.eclipse.mylyn.core.model.interest.propagation";
    public static final String SOURCE_ID_DECAY = "org.eclipse.mylyn.core.model.interest.decay";
    public static final String SOURCE_ID_DECAY_CORRECTION = "org.eclipse.mylyn.core.model.interest.decay.correction";
    public static final String SOURCE_ID_MODEL_ERROR = "org.eclipse.mylyn.core.model.interest.propagation";
    public static final String CONTAINMENT_PROPAGATION_ID = "org.eclipse.mylyn.core.model.edges.containment";
    public static final String CONTEXT_FILE_EXTENSION = ".xml.zip";
    public static final String CONTEXT_FILE_EXTENSION_OLD = ".xml";
    private static final int MAX_PROPAGATION = 17;
    private int numInterestingErrors = 0;
    private List<String> errorElementHandles = new ArrayList<String>();
    private Set<File> contextFiles = null;
    private boolean contextCapturePaused = false;
    private CompositeInteractionContext activeContext = new CompositeInteractionContext(InteractionContextManager.getCommonContextScaling());
    private Collection<IInteractionContext> globalContexts = new HashSet<IInteractionContext>();
    private InteractionContext activityMetaContext = null;
    private List<IInteractionContextListener> activityMetaContextListeners = new CopyOnWriteArrayList<IInteractionContextListener>();
    private List<IInteractionContextListener> contextListeners = new CopyOnWriteArrayList<IInteractionContextListener>();
    private List<IInteractionContextListener> waitingContextListeners = new ArrayList<IInteractionContextListener>();
    private boolean suppressListenerNotification = false;
    private InteractionContextExternalizer externalizer = new InteractionContextExternalizer();
    private boolean activationHistorySuppressed = false;
    private static InteractionContextScaling commonContextScaling = new InteractionContextScaling();

    public InteractionContext getActivityMetaContext() {
        if (this.activityMetaContext == null) {
            this.loadActivityMetaContext();
        }
        return this.activityMetaContext;
    }

    public void loadActivityMetaContext() {
        if (ContextCorePlugin.getDefault().getContextStore() != null) {
            for (IInteractionContextListener listener : this.activityMetaContextListeners) {
                if (!(listener instanceof IInteractionContextListener2)) continue;
                ((IInteractionContextListener2)listener).contextPreActivated(this.activityMetaContext);
            }
            File contextActivityFile = this.getFileForContext(CONTEXT_HISTORY_FILE_NAME);
            this.activityMetaContext = this.externalizer.readContextFromXML(CONTEXT_HISTORY_FILE_NAME, contextActivityFile, commonContextScaling);
            if (this.activityMetaContext == null) {
                this.resetActivityHistory();
            } else if (!ContextCorePlugin.getDefault().getPluginPreferences().getBoolean(PREFERENCE_ATTENTION_MIGRATED)) {
                this.activityMetaContext = this.migrateLegacyActivity(this.activityMetaContext);
                this.saveActivityContext();
                ContextCorePlugin.getDefault().getPluginPreferences().setValue(PREFERENCE_ATTENTION_MIGRATED, true);
                ContextCorePlugin.getDefault().savePluginPreferences();
            }
            for (IInteractionContextListener listener : this.activityMetaContextListeners) {
                listener.contextActivated(this.activityMetaContext);
            }
        } else {
            this.resetActivityHistory();
            StatusHandler.log((IStatus)new Status(1, "org.eclipse.mylyn.core", "No context store installed, not restoring activity context."));
        }
    }

    private InteractionContext migrateLegacyActivity(InteractionContext context) {
        LegacyActivityAdaptor adaptor = new LegacyActivityAdaptor();
        InteractionContext newMetaContext = new InteractionContext(context.getHandleIdentifier(), InteractionContextManager.getCommonContextScaling());
        for (InteractionEvent event : context.getInteractionHistory()) {
            InteractionEvent temp = adaptor.parseInteractionEvent(event);
            if (temp == null) continue;
            newMetaContext.parseEvent(temp);
        }
        return newMetaContext;
    }

    public void processActivityMetaContextEvent(InteractionEvent event) {
        IInteractionElement element = this.getActivityMetaContext().parseEvent(event);
        for (IInteractionContextListener listener : this.activityMetaContextListeners) {
            try {
                ArrayList<IInteractionElement> changed = new ArrayList<IInteractionElement>();
                changed.add(element);
                listener.interestChanged(changed);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.core", "Context listener failed: " + listener.getClass().getCanonicalName(), t));
            }
        }
    }

    public void resetActivityHistory() {
        this.activityMetaContext = new InteractionContext(CONTEXT_HISTORY_FILE_NAME, InteractionContextManager.getCommonContextScaling());
        this.saveActivityContext();
    }

    public IInteractionElement getActiveElement() {
        if (this.activeContext != null) {
            return this.activeContext.getActiveNode();
        }
        return null;
    }

    public void addErrorPredictedInterest(String handle, String kind, boolean notify) {
        if (this.numInterestingErrors > commonContextScaling.getMaxNumInterestingErrors() || this.activeContext.getContextMap().isEmpty()) {
            return;
        }
        InteractionEvent errorEvent = new InteractionEvent(InteractionEvent.Kind.PROPAGATION, kind, handle, "org.eclipse.mylyn.core.model.interest.propagation", commonContextScaling.getErrorInterest());
        this.processInteractionEvent(errorEvent, true);
        this.errorElementHandles.add(handle);
        ++this.numInterestingErrors;
    }

    public void removeErrorPredictedInterest(String handle, String kind, boolean notify) {
        if (this.activeContext.getContextMap().isEmpty()) {
            return;
        }
        if (handle == null) {
            return;
        }
        IInteractionElement element = this.activeContext.get(handle);
        if (element != null && element.getInterest().isInteresting() && this.errorElementHandles.contains(handle)) {
            InteractionEvent errorEvent = new InteractionEvent(InteractionEvent.Kind.MANIPULATION, kind, handle, "org.eclipse.mylyn.core.model.interest.propagation", -commonContextScaling.getErrorInterest());
            this.processInteractionEvent(errorEvent, true);
            --this.numInterestingErrors;
            this.errorElementHandles.remove(handle);
            if (notify) {
                for (IInteractionContextListener listener : this.contextListeners) {
                    ArrayList<IInteractionElement> changed = new ArrayList<IInteractionElement>();
                    changed.add(element);
                    listener.interestChanged(changed);
                }
            }
        }
    }

    public IInteractionElement getElement(String elementHandle) {
        if (this.activeContext != null && elementHandle != null) {
            return this.activeContext.get(elementHandle);
        }
        return null;
    }

    public IInteractionElement processInteractionEvent(Object object, InteractionEvent.Kind eventKind, String origin, IInteractionContext context) {
        AbstractContextStructureBridge structureBridge = ContextCorePlugin.getDefault().getStructureBridge(object);
        if (structureBridge != null) {
            String structureKind = structureBridge.getContentType();
            String handle = structureBridge.getHandleIdentifier(object);
            if (structureKind != null && handle != null) {
                InteractionEvent event = new InteractionEvent(eventKind, structureKind, handle, origin);
                List<IInteractionElement> interestDelta = this.internalProcessInteractionEvent(event, context, true);
                this.notifyInterestDelta(interestDelta);
                return context.get(event.getStructureHandle());
            }
        }
        return null;
    }

    public IInteractionElement processInteractionEvent(InteractionEvent event) {
        return this.processInteractionEvent(event, true);
    }

    public IInteractionElement processInteractionEvent(InteractionEvent event, boolean propagateToParents) {
        return this.processInteractionEvent(event, propagateToParents, true);
    }

    public void processInteractionEvents(List<InteractionEvent> events, boolean propagateToParents) {
        HashSet<IInteractionElement> compositeDelta = new HashSet<IInteractionElement>();
        for (InteractionEvent event : events) {
            if (this.isContextActive()) {
                compositeDelta.addAll(this.internalProcessInteractionEvent(event, this.activeContext, propagateToParents));
            }
            for (IInteractionContext globalContext : this.globalContexts) {
                if (!globalContext.getContentLimitedTo().equals(event.getStructureKind())) continue;
                this.internalProcessInteractionEvent(event, globalContext, propagateToParents);
            }
        }
        this.notifyInterestDelta(new ArrayList<IInteractionElement>(compositeDelta));
    }

    public IInteractionElement processInteractionEvent(InteractionEvent event, boolean propagateToParents, boolean notifyListeners) {
        boolean alreadyNotified = false;
        if (this.isContextActive()) {
            List<IInteractionElement> interestDelta = this.internalProcessInteractionEvent(event, this.activeContext, propagateToParents);
            if (notifyListeners) {
                this.notifyInterestDelta(interestDelta);
            }
        }
        for (IInteractionContext globalContext : this.globalContexts) {
            if (!globalContext.getContentLimitedTo().equals(event.getStructureKind())) continue;
            List<IInteractionElement> interestDelta = this.internalProcessInteractionEvent(event, globalContext, propagateToParents);
            if (!notifyListeners || alreadyNotified) continue;
            this.notifyInterestDelta(interestDelta);
        }
        return this.activeContext.get(event.getStructureHandle());
    }

    private List<IInteractionElement> internalProcessInteractionEvent(InteractionEvent event, IInteractionContext interactionContext, boolean propagateToParents) {
        if (this.contextCapturePaused || InteractionEvent.Kind.COMMAND.equals((Object)event.getKind()) || this.suppressListenerNotification) {
            return Collections.emptyList();
        }
        IInteractionElement previous = interactionContext.get(event.getStructureHandle());
        float previousInterest = 0.0f;
        boolean previouslyPredicted = false;
        boolean previouslyPropagated = false;
        float decayOffset = 0.0f;
        if (previous != null) {
            previousInterest = previous.getInterest().getValue();
            previouslyPredicted = previous.getInterest().isPredicted();
            previouslyPropagated = previous.getInterest().isPropagated();
        }
        if (event.getKind().isUserEvent()) {
            decayOffset = this.ensureIsInteresting(interactionContext, event.getStructureKind(), event.getStructureHandle(), previous, previousInterest);
        }
        IInteractionElement element = this.addInteractionEvent(interactionContext, event);
        ArrayList<IInteractionElement> interestDelta = new ArrayList<IInteractionElement>();
        if (propagateToParents && !event.getKind().equals((Object)InteractionEvent.Kind.MANIPULATION)) {
            this.propegateInterestToParents(interactionContext, event.getKind(), element, previousInterest, decayOffset, 1, interestDelta);
        }
        if (event.getKind().isUserEvent() && interactionContext instanceof CompositeInteractionContext) {
            ((CompositeInteractionContext)interactionContext).setActiveElement(element);
        }
        if (this.isInterestDelta(previousInterest, previouslyPredicted, previouslyPropagated, element)) {
            interestDelta.add(element);
        }
        this.checkForLandmarkDeltaAndNotify(previousInterest, element);
        return interestDelta;
    }

    private IInteractionElement addInteractionEvent(IInteractionContext interactionContext, InteractionEvent event) {
        if (interactionContext instanceof CompositeInteractionContext) {
            return ((CompositeInteractionContext)interactionContext).addEvent(event);
        }
        if (interactionContext instanceof InteractionContext) {
            return ((InteractionContext)interactionContext).parseEvent(event);
        }
        return null;
    }

    private float ensureIsInteresting(IInteractionContext interactionContext, String contentType, String handle, IInteractionElement previous, float previousInterest) {
        float decayOffset = 0.0f;
        if (previousInterest < 0.0f) {
            decayOffset = -1.0f * previous.getInterest().getValue();
            this.addInteractionEvent(interactionContext, new InteractionEvent(InteractionEvent.Kind.MANIPULATION, contentType, handle, SOURCE_ID_DECAY_CORRECTION, decayOffset));
        }
        return decayOffset;
    }

    private void notifyInterestDelta(List<IInteractionElement> interestDelta) {
        if (!interestDelta.isEmpty()) {
            for (IInteractionContextListener listener : this.contextListeners) {
                listener.interestChanged(interestDelta);
            }
        }
    }

    private void notifyElementsDeleted(List<IInteractionElement> interestDelta) {
        if (!interestDelta.isEmpty()) {
            for (IInteractionContextListener listener : this.contextListeners) {
                if (listener instanceof IInteractionContextListener2) {
                    ((IInteractionContextListener2)listener).elementsDeleted(interestDelta);
                    continue;
                }
                for (IInteractionElement element : interestDelta) {
                    listener.elementDeleted(element);
                }
            }
        }
    }

    protected boolean isInterestDelta(float previousInterest, boolean previouslyPredicted, boolean previouslyPropagated, IInteractionElement node) {
        float currentInterest = node.getInterest().getValue();
        if (previousInterest <= 0.0f && currentInterest > 0.0f) {
            return true;
        }
        if (previousInterest > 0.0f && currentInterest <= 0.0f) {
            return true;
        }
        if (currentInterest > 0.0f && previouslyPredicted && !node.getInterest().isPredicted()) {
            return true;
        }
        return currentInterest > 0.0f && previouslyPropagated && !node.getInterest().isPropagated();
    }

    protected void checkForLandmarkDeltaAndNotify(float previousInterest, IInteractionElement node) {
        block2: {
            block3: {
                AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
                if (!bridge.canBeLandmark(node.getHandleIdentifier())) break block2;
                if (!(previousInterest >= commonContextScaling.getLandmark()) || node.getInterest().isLandmark()) break block3;
                for (IInteractionContextListener listener : this.contextListeners) {
                    listener.landmarkRemoved(node);
                }
                break block2;
            }
            if (!(previousInterest < commonContextScaling.getLandmark()) || !node.getInterest().isLandmark()) break block2;
            for (IInteractionContextListener listener : this.contextListeners) {
                listener.landmarkAdded(node);
            }
        }
    }

    private void propegateInterestToParents(IInteractionContext interactionContext, InteractionEvent.Kind kind, IInteractionElement node, float previousInterest, float decayOffset, int level, List<IInteractionElement> interestDelta) {
        if (level > 17 || node == null || node.getHandleIdentifier() == null || node.getInterest().getValue() <= 0.0f) {
            return;
        }
        this.checkForLandmarkDeltaAndNotify(previousInterest, node);
        ++level;
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
        String parentHandle = bridge.getParentHandle(node.getHandleIdentifier());
        for (String contentType : ContextCorePlugin.getDefault().getChildContentTypes(bridge.getContentType())) {
            AbstractContextStructureBridge canonicalBridge;
            AbstractContextStructureBridge childBridge = ContextCorePlugin.getDefault().getStructureBridge(contentType);
            Object resolved = childBridge.getObjectForHandle(parentHandle);
            if (resolved == null || (canonicalBridge = ContextCorePlugin.getDefault().getStructureBridge(resolved)).getContentType().equals("resource")) continue;
            bridge = canonicalBridge;
        }
        if (parentHandle != null) {
            String parentContentType = bridge.getContentType(parentHandle);
            IInteractionElement parentElement = interactionContext.get(parentHandle);
            float parentPreviousInterest = 0.0f;
            if (parentElement != null && parentElement.getInterest() != null) {
                parentPreviousInterest = parentElement.getInterest().getValue();
            }
            float increment = interactionContext.getScaling().getInteresting();
            if (parentPreviousInterest < node.getInterest().getValue()) {
                increment = node.getInterest().getValue() - parentPreviousInterest;
                InteractionEvent propagationEvent = new InteractionEvent(InteractionEvent.Kind.PROPAGATION, parentContentType, parentHandle, "org.eclipse.mylyn.core.model.interest.propagation", CONTAINMENT_PROPAGATION_ID, increment);
                parentElement = this.addInteractionEvent(interactionContext, propagationEvent);
            }
            if (parentElement != null && kind.isUserEvent() && parentElement.getInterest().getValue() < commonContextScaling.getInteresting()) {
                float parentOffset = commonContextScaling.getInteresting() - parentElement.getInterest().getValue() + increment;
                this.addInteractionEvent(interactionContext, new InteractionEvent(InteractionEvent.Kind.MANIPULATION, parentElement.getContentType(), parentElement.getHandleIdentifier(), SOURCE_ID_DECAY_CORRECTION, parentOffset));
            }
            if (parentElement != null && this.isInterestDelta(parentPreviousInterest, parentElement.getInterest().isPredicted(), parentElement.getInterest().isPropagated(), parentElement)) {
                interestDelta.add(0, parentElement);
            }
            this.propegateInterestToParents(interactionContext, kind, parentElement, parentPreviousInterest, decayOffset, level, interestDelta);
        }
    }

    public void addListener(IInteractionContextListener listener) {
        if (listener != null) {
            if (this.suppressListenerNotification && !this.waitingContextListeners.contains(listener)) {
                this.waitingContextListeners.add(listener);
            } else if (!this.contextListeners.contains(listener)) {
                this.contextListeners.add(listener);
            }
        } else {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.core", "Attempted to add null lisetener", (Throwable)new Exception()));
        }
    }

    public void removeListener(IInteractionContextListener listener) {
        this.waitingContextListeners.remove(listener);
        this.contextListeners.remove(listener);
    }

    public void addActivityMetaContextListener(IInteractionContextListener listener) {
        this.activityMetaContextListeners.add(listener);
    }

    public void removeActivityMetaContextListener(IInteractionContextListener listener) {
        this.activityMetaContextListeners.remove(listener);
    }

    public void removeAllListeners() {
        this.waitingContextListeners.clear();
        this.contextListeners.clear();
    }

    public void internalActivateContext(InteractionContext context) {
        System.setProperty(PROPERTY_CONTEXT_ACTIVE, Boolean.TRUE.toString());
        this.activeContext.getContextMap().put(context.getHandleIdentifier(), context);
        if (this.contextFiles != null) {
            this.contextFiles.add(this.getFileForContext(context.getHandleIdentifier()));
        }
        if (!this.activationHistorySuppressed) {
            this.processActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.COMMAND, ACTIVITY_STRUCTUREKIND_ACTIVATION, context.getHandleIdentifier(), ACTIVITY_ORIGINID_WORKBENCH, null, ACTIVITY_DELTA_ACTIVATED, 1.0f));
        }
        for (IInteractionContextListener listener : this.contextListeners) {
            try {
                listener.contextActivated(context);
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.core", "Context listener failed: " + listener.getClass().getCanonicalName(), (Throwable)e));
            }
        }
    }

    public Collection<InteractionContext> getActiveContexts() {
        return Collections.unmodifiableCollection(this.activeContext.getContextMap().values());
    }

    public void activateContext(String handleIdentifier) {
        try {
            InteractionContext context = this.activeContext.getContextMap().get(handleIdentifier);
            if (context == null) {
                context = this.loadContext(handleIdentifier);
            }
            for (IInteractionContextListener listener : this.contextListeners) {
                if (!(listener instanceof IInteractionContextListener2)) continue;
                ((IInteractionContextListener2)listener).contextPreActivated(context);
            }
            if (context != null) {
                this.suppressListenerNotification = true;
                this.internalActivateContext(context);
            } else {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.core", "Could not load context"));
            }
            this.suppressListenerNotification = false;
            this.contextListeners.addAll(this.waitingContextListeners);
            this.waitingContextListeners.clear();
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.core", "Could not activate context", t));
        }
    }

    public boolean hasContext(String handleIdentifier) {
        if (handleIdentifier == null) {
            return false;
        }
        if (this.contextFiles == null) {
            File[] files;
            this.contextFiles = new HashSet<File>();
            File contextDirectory = ContextCorePlugin.getDefault().getContextStore().getContextDirectory();
            File[] fileArray = files = contextDirectory.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.contextFiles.add(file);
                ++n2;
            }
        }
        if (this.getActiveContext() != null && handleIdentifier.equals(this.getActiveContext().getHandleIdentifier())) {
            return !this.getActiveContext().getAllElements().isEmpty();
        }
        File file = this.getFileForContext(handleIdentifier);
        return this.contextFiles.contains(file);
    }

    public void deactivateAllContexts() {
        HashSet handles = new HashSet(this.activeContext.getContextMap().keySet());
        for (String handleIdentifier : handles) {
            this.deactivateContext(handleIdentifier);
        }
    }

    public void deactivateContext(String handleIdentifier) {
        try {
            System.setProperty(PROPERTY_CONTEXT_ACTIVE, Boolean.FALSE.toString());
            IInteractionContext context = this.activeContext.getContextMap().get(handleIdentifier);
            if (context != null) {
                this.saveContext(handleIdentifier);
                this.activeContext.getContextMap().remove(handleIdentifier);
                this.setContextCapturePaused(true);
                for (IInteractionContextListener listener : this.contextListeners) {
                    try {
                        listener.contextDeactivated(context);
                    }
                    catch (Exception e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.core", "Context listener failed: " + listener.getClass().getCanonicalName(), (Throwable)e));
                    }
                }
                if (context.getAllElements().size() == 0) {
                    this.contextFiles.remove(this.getFileForContext(context.getHandleIdentifier()));
                }
                this.setContextCapturePaused(false);
            }
            if (!this.activationHistorySuppressed) {
                this.processActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.COMMAND, ACTIVITY_STRUCTUREKIND_ACTIVATION, handleIdentifier, ACTIVITY_ORIGINID_WORKBENCH, null, ACTIVITY_DELTA_DEACTIVATED, 1.0f));
            }
            this.saveActivityContext();
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.core", "Could not deactivate context", t));
        }
    }

    public void deleteContext(String handleIdentifier) {
        IInteractionContext context = this.activeContext.getContextMap().get(handleIdentifier);
        this.eraseContext(handleIdentifier, false);
        try {
            File file = this.getFileForContext(handleIdentifier);
            if (file.exists()) {
                file.delete();
            }
            this.setContextCapturePaused(true);
            for (IInteractionContextListener listener : this.contextListeners) {
                listener.contextCleared(context);
            }
            this.setContextCapturePaused(false);
            if (this.contextFiles != null) {
                this.contextFiles.remove(this.getFileForContext(handleIdentifier));
            }
        }
        catch (SecurityException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.core", "Could not delete context file", (Throwable)e));
        }
    }

    private void eraseContext(String handleIdentifier, boolean notify) {
        InteractionContext context;
        if (this.contextFiles != null) {
            this.contextFiles.remove(this.getFileForContext(handleIdentifier));
        }
        if ((context = this.activeContext.getContextMap().get(handleIdentifier)) == null) {
            return;
        }
        this.activeContext.getContextMap().remove(context);
        context.reset();
    }

    public InteractionContext loadContext(String handleIdentifier) {
        return this.loadContext(handleIdentifier, this.getFileForContext(handleIdentifier));
    }

    public InteractionContext loadContext(String handleIdentifier, InteractionContextScaling contextScaling) {
        return this.loadContext(handleIdentifier, this.getFileForContext(handleIdentifier), contextScaling);
    }

    public InteractionContext loadContext(String handleIdentifier, File file) {
        return this.loadContext(handleIdentifier, file, InteractionContextManager.getCommonContextScaling());
    }

    private InteractionContext loadContext(String handleIdentifier, File file, InteractionContextScaling contextScaling) {
        InteractionContext loadedContext = this.externalizer.readContextFromXML(handleIdentifier, file, contextScaling);
        if (loadedContext == null) {
            return new InteractionContext(handleIdentifier, contextScaling);
        }
        return loadedContext;
    }

    public void saveContext(String handleIdentifier) {
        InteractionContext context = this.activeContext.getContextMap().get(handleIdentifier);
        if (context == null) {
            return;
        }
        this.saveContext(context);
    }

    public void saveContext(InteractionContext context) {
        boolean wasPaused = this.contextCapturePaused;
        try {
            try {
                if (!wasPaused) {
                    this.setContextCapturePaused(true);
                }
                context.collapse();
                this.externalizer.writeContextToXml(context, this.getFileForContext(context.getHandleIdentifier()));
                if (this.contextFiles == null) {
                    this.contextFiles = new HashSet<File>();
                }
                this.contextFiles.add(this.getFileForContext(context.getHandleIdentifier()));
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.core", "could not save context", t));
                if (!wasPaused) {
                    this.setContextCapturePaused(false);
                }
            }
        }
        finally {
            if (!wasPaused) {
                this.setContextCapturePaused(false);
            }
        }
    }

    public void importContext(InteractionContext context) {
        this.externalizer.writeContextToXml(context, this.getFileForContext(context.getHandleIdentifier()));
        if (this.contextFiles == null) {
            this.contextFiles = new HashSet<File>();
        }
        this.contextFiles.add(this.getFileForContext(context.getHandleIdentifier()));
        this.activeContext.getContextMap().put(context.getHandleIdentifier(), context);
        if (!this.activationHistorySuppressed) {
            this.processActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.COMMAND, ACTIVITY_STRUCTUREKIND_ACTIVATION, context.getHandleIdentifier(), ACTIVITY_ORIGINID_WORKBENCH, null, ACTIVITY_DELTA_ACTIVATED, 1.0f));
        }
    }

    public void saveActivityContext() {
        if (ContextCorePlugin.getDefault().getContextStore() == null) {
            return;
        }
        boolean wasPaused = this.contextCapturePaused;
        try {
            try {
                if (!wasPaused) {
                    this.setContextCapturePaused(true);
                }
                InteractionContext context = this.getActivityMetaContext();
                this.externalizer.writeContextToXml(this.collapseActivityMetaContext(context), this.getFileForContext(CONTEXT_HISTORY_FILE_NAME));
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.core", "Could not save activity history", t));
                if (!wasPaused) {
                    this.setContextCapturePaused(false);
                }
            }
        }
        finally {
            if (!wasPaused) {
                this.setContextCapturePaused(false);
            }
        }
    }

    public InteractionContext collapseActivityMetaContext(InteractionContext context) {
        HashMap<String, List<InteractionEvent>> attention = new HashMap<String, List<InteractionEvent>>();
        InteractionContext tempContext = new InteractionContext(CONTEXT_HISTORY_FILE_NAME, InteractionContextManager.getCommonContextScaling());
        for (InteractionEvent event : context.getInteractionHistory()) {
            if (event.getKind().equals((Object)InteractionEvent.Kind.ATTENTION) && event.getDelta().equals(ACTIVITY_DELTA_ADDED)) {
                if (event.getStructureHandle() == null || event.getStructureHandle().equals("")) continue;
                ArrayList<InteractionEvent> interactionEvents = (ArrayList<InteractionEvent>)attention.get(event.getStructureHandle());
                if (interactionEvents == null) {
                    interactionEvents = new ArrayList<InteractionEvent>();
                    attention.put(event.getStructureHandle(), interactionEvents);
                }
                interactionEvents.add(event);
                continue;
            }
            if (!attention.isEmpty()) {
                this.addAttentionEvents(attention, tempContext);
                attention.clear();
            }
            tempContext.parseEvent(event);
        }
        if (!attention.isEmpty()) {
            this.addAttentionEvents(attention, tempContext);
        }
        return tempContext;
    }

    private void addAttentionEvents(Map<String, List<InteractionEvent>> attention, InteractionContext temp) {
        try {
            for (String handle : attention.keySet()) {
                List<InteractionEvent> activityEvents = attention.get(handle);
                List<Object> collapsedEvents = new ArrayList();
                if (activityEvents.size() > 1) {
                    collapsedEvents = this.collapseEventsByHour(activityEvents);
                } else if (activityEvents.size() == 1 && activityEvents.get(0).getEndDate().getTime() - activityEvents.get(0).getDate().getTime() > 0L) {
                    collapsedEvents.add(activityEvents.get(0));
                }
                if (!collapsedEvents.isEmpty()) {
                    for (InteractionEvent interactionEvent : collapsedEvents) {
                        temp.parseEvent(interactionEvent);
                    }
                }
                activityEvents.clear();
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.core", "Error during meta activity collapse", (Throwable)e));
        }
    }

    public List<InteractionEvent> collapseEventsByHour(List<InteractionEvent> eventsToCollapse) {
        ArrayList<InteractionEvent> collapsedEvents = new ArrayList<InteractionEvent>();
        Iterator<InteractionEvent> itr = eventsToCollapse.iterator();
        InteractionEvent firstEvent = itr.next();
        long total = 0L;
        Calendar t0 = Calendar.getInstance();
        Calendar t1 = Calendar.getInstance();
        while (itr.hasNext()) {
            InteractionEvent aggregateEvent;
            Date newEndDate;
            t0.setTime(firstEvent.getDate());
            t0.set(12, 0);
            t0.set(14, 0);
            t1.setTime(firstEvent.getDate());
            t1.set(12, t1.getMaximum(12));
            t1.set(14, t1.getMaximum(14));
            InteractionEvent nextEvent = itr.next();
            if (t0.getTime().compareTo(nextEvent.getDate()) <= 0 && t1.getTime().compareTo(nextEvent.getDate()) >= 0) {
                if (total == 0L) {
                    total += firstEvent.getEndDate().getTime() - firstEvent.getDate().getTime();
                }
                if (itr.hasNext() || (total += nextEvent.getEndDate().getTime() - nextEvent.getDate().getTime()) == 0L) continue;
                newEndDate = new Date(firstEvent.getDate().getTime() + total);
                aggregateEvent = new InteractionEvent(firstEvent.getKind(), firstEvent.getStructureKind(), firstEvent.getStructureHandle(), firstEvent.getOriginId(), firstEvent.getNavigation(), firstEvent.getDelta(), 1.0f, firstEvent.getDate(), newEndDate);
                collapsedEvents.add(aggregateEvent);
                total = 0L;
                continue;
            }
            if (total != 0L) {
                newEndDate = new Date(firstEvent.getDate().getTime() + total);
                aggregateEvent = new InteractionEvent(firstEvent.getKind(), firstEvent.getStructureKind(), firstEvent.getStructureHandle(), firstEvent.getOriginId(), firstEvent.getNavigation(), firstEvent.getDelta(), 1.0f, firstEvent.getDate(), newEndDate);
                collapsedEvents.add(aggregateEvent);
                total = 0L;
            } else {
                collapsedEvents.add(firstEvent);
                if (!itr.hasNext()) {
                    collapsedEvents.add(nextEvent);
                }
            }
            firstEvent = nextEvent;
        }
        return collapsedEvents;
    }

    public File getFileForContext(String handleIdentifier) {
        try {
            String encoded = URLEncoder.encode(handleIdentifier, CONTEXT_FILENAME_ENCODING);
            File contextDirectory = ContextCorePlugin.getDefault().getContextStore().getContextDirectory();
            File contextFile = new File(contextDirectory, String.valueOf(encoded) + CONTEXT_FILE_EXTENSION);
            return contextFile;
        }
        catch (UnsupportedEncodingException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.core", "Could not determine path for context", (Throwable)e));
            return null;
        }
    }

    public IInteractionContext getActiveContext() {
        return this.activeContext;
    }

    public void resetLandmarkRelationshipsOfKind(String reltationKind) {
        for (IInteractionElement landmark : this.activeContext.getLandmarks()) {
            for (IInteractionRelation iInteractionRelation : landmark.getRelations()) {
                if (!iInteractionRelation.getRelationshipHandle().equals(reltationKind)) continue;
                landmark.clearRelations();
            }
        }
        for (IInteractionContextListener listener : this.contextListeners) {
            listener.relationsChanged(null);
        }
    }

    public void notifyRelationshipsChanged(IInteractionElement node) {
        if (this.suppressListenerNotification) {
            return;
        }
        for (IInteractionContextListener listener : this.contextListeners) {
            listener.relationsChanged(node);
        }
    }

    public static InteractionContextScaling getCommonContextScaling() {
        return commonContextScaling;
    }

    public boolean isContextActive() {
        return !this.contextCapturePaused && this.activeContext.getContextMap().values().size() > 0;
    }

    @Deprecated
    public boolean isContextActivePropertySet() {
        return Boolean.parseBoolean(System.getProperty(PROPERTY_CONTEXT_ACTIVE));
    }

    public List<IInteractionElement> getActiveLandmarks() {
        List<IInteractionElement> allLandmarks = this.activeContext.getLandmarks();
        ArrayList<IInteractionElement> acceptedLandmarks = new ArrayList<IInteractionElement>();
        for (IInteractionElement node : allLandmarks) {
            AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
            if (!bridge.canBeLandmark(node.getHandleIdentifier())) continue;
            acceptedLandmarks.add(node);
        }
        return acceptedLandmarks;
    }

    public Collection<IInteractionElement> getInterestingDocuments(IInteractionContext context) {
        HashSet<IInteractionElement> set = new HashSet<IInteractionElement>();
        if (context == null) {
            return set;
        }
        List<IInteractionElement> allIntersting = context.getInteresting();
        for (IInteractionElement node : allIntersting) {
            if (!ContextCorePlugin.getDefault().getStructureBridge(node.getContentType()).isDocument(node.getHandleIdentifier())) continue;
            set.add(node);
        }
        return set;
    }

    public Collection<IInteractionElement> getInterestingDocuments() {
        return this.getInterestingDocuments(this.activeContext);
    }

    public boolean isActivationHistorySuppressed() {
        return this.activationHistorySuppressed;
    }

    public void setActivationHistorySuppressed(boolean activationHistorySuppressed) {
        this.activationHistorySuppressed = activationHistorySuppressed;
    }

    public boolean manipulateInterestForElement(IInteractionElement element, boolean increment, boolean forceLandmark, boolean preserveUninteresting, String sourceId) {
        if (!this.isContextActive()) {
            return false;
        }
        return this.manipulateInterestForElement(element, increment, forceLandmark, preserveUninteresting, sourceId, this.activeContext);
    }

    public boolean manipulateInterestForElement(IInteractionElement element, boolean increment, boolean forceLandmark, boolean preserveUninteresting, String sourceId, IInteractionContext context) {
        HashSet<IInteractionElement> changedElements = new HashSet<IInteractionElement>();
        boolean manipulated = this.manipulateInterestForElementHelper(element, increment, forceLandmark, preserveUninteresting, sourceId, context, changedElements);
        if (manipulated) {
            if (preserveUninteresting || increment) {
                this.notifyInterestDelta(new ArrayList<IInteractionElement>(changedElements));
            } else {
                this.notifyElementsDeleted(new ArrayList<IInteractionElement>(changedElements));
            }
        }
        return manipulated;
    }

    private boolean manipulateInterestForElementHelper(IInteractionElement element, boolean increment, boolean forceLandmark, boolean preserveUninteresting, String sourceId, IInteractionContext context, Set<IInteractionElement> changedElements) {
        if (element == null || context == null) {
            return false;
        }
        float originalValue = element.getInterest().getValue();
        float changeValue = 0.0f;
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(element.getContentType());
        if (!increment) {
            if (element.getInterest().isLandmark() && bridge.canBeLandmark(element.getHandleIdentifier())) {
                changeValue = -1.0f * originalValue + 1.0f;
            } else {
                if (originalValue >= 0.0f) {
                    changeValue = -1.0f * originalValue - 1.0f;
                }
                for (String childHandle : bridge.getChildHandles(element.getHandleIdentifier())) {
                    IInteractionElement childElement = context.get(childHandle);
                    if (childElement == null || childElement.equals(element)) continue;
                    this.manipulateInterestForElementHelper(childElement, increment, forceLandmark, preserveUninteresting, sourceId, context, changedElements);
                }
            }
        } else if (!forceLandmark && originalValue > context.getScaling().getLandmark()) {
            changeValue = 0.0f;
        } else if (bridge.canBeLandmark(element.getHandleIdentifier())) {
            changeValue = context.getScaling().getForcedLandmark() - originalValue + 1.0f;
        } else {
            return false;
        }
        if (increment || preserveUninteresting) {
            InteractionEvent interactionEvent = new InteractionEvent(InteractionEvent.Kind.MANIPULATION, element.getContentType(), element.getHandleIdentifier(), sourceId, changeValue);
            List<IInteractionElement> interestDelta = this.internalProcessInteractionEvent(interactionEvent, context, true);
            changedElements.addAll(interestDelta);
        } else {
            changedElements.add(element);
            this.delete(element, context);
        }
        return true;
    }

    public void setActiveSearchEnabled(boolean enabled) {
        for (AbstractRelationProvider provider : ContextCorePlugin.getDefault().getRelationProviders()) {
            provider.setEnabled(enabled);
        }
    }

    public String getDominantContextHandleForElement(IInteractionElement node) {
        IInteractionElement dominantNode = null;
        if (node instanceof CompositeContextElement) {
            CompositeContextElement compositeNode = (CompositeContextElement)node;
            if (compositeNode.getNodes().isEmpty()) {
                return null;
            }
            dominantNode = (IInteractionElement)compositeNode.getNodes().toArray()[0];
            for (IInteractionElement iInteractionElement : compositeNode.getNodes()) {
                if (dominantNode == null || !(dominantNode.getInterest().getValue() < iInteractionElement.getInterest().getValue())) continue;
                dominantNode = iInteractionElement;
            }
        } else if (node instanceof InteractionContextElement) {
            dominantNode = node;
        }
        if (dominantNode != null) {
            return ((InteractionContextElement)dominantNode).getContext().getHandleIdentifier();
        }
        return null;
    }

    public void updateHandle(IInteractionElement element, String newHandle) {
        if (element == null) {
            return;
        }
        this.getActiveContext().updateElementHandle(element, newHandle);
        for (IInteractionContextListener listener : this.contextListeners) {
            ArrayList<IInteractionElement> changed = new ArrayList<IInteractionElement>();
            changed.add(element);
            listener.interestChanged(changed);
        }
        if (element.getInterest().isLandmark()) {
            for (IInteractionContextListener listener : this.contextListeners) {
                listener.landmarkAdded(element);
            }
        }
    }

    public void delete(IInteractionElement element) {
        this.delete(element, this.getActiveContext());
        this.notifyElementsDeleted(Arrays.asList(element));
    }

    private void delete(IInteractionElement element, IInteractionContext context) {
        if (element == null || context == null) {
            return;
        }
        context.delete(element);
    }

    public void setContextCapturePaused(boolean paused) {
        this.contextCapturePaused = paused;
    }

    public boolean isContextCapturePaused() {
        return this.contextCapturePaused;
    }

    public List<IInteractionContextListener> getListeners() {
        return Collections.unmodifiableList(this.contextListeners);
    }

    public boolean isValidContextFile(File file) {
        if (file.exists() && file.getName().endsWith(CONTEXT_FILE_EXTENSION)) {
            InteractionContext context = this.externalizer.readContextFromXML("temp", file, commonContextScaling);
            return context != null;
        }
        return false;
    }

    public void copyContext(String targetcontextHandle, File sourceContextFile) {
        File targetContextFile = this.getFileForContext(targetcontextHandle);
        targetContextFile.delete();
        try {
            this.copy(sourceContextFile, targetContextFile);
            this.contextFiles.add(targetContextFile);
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.core", "Cold not transfer context: " + targetcontextHandle, (Throwable)e));
        }
    }

    public void cloneContext(String sourceContextHandle, String destinationContextHandle) {
        InteractionContext source = this.loadContext(sourceContextHandle);
        if (source != null) {
            source.setHandleIdentifier(destinationContextHandle);
            this.saveContext(source);
        }
    }

    private void copy(File src, File dest) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public void addGlobalContext(IInteractionContext context) {
        this.globalContexts.add(context);
    }

    public void removeGlobalContext(IInteractionContext context) {
        this.globalContexts.remove(context);
    }

    public Collection<IInteractionContext> getGlobalContexts() {
        return this.globalContexts;
    }
}

