/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.CompositeContextElement;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextElement;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeInteractionContext
implements IInteractionContext {
    protected Map<String, InteractionContext> contexts = new HashMap<String, InteractionContext>();
    protected IInteractionElement activeNode = null;
    private InteractionContextScaling contextScaling;
    public String contentLimitedTo = null;

    public CompositeInteractionContext(InteractionContextScaling contextScaling) {
        this.contextScaling = contextScaling;
    }

    public IInteractionElement addEvent(InteractionEvent event) {
        ArrayList<InteractionContextElement> nodes = new ArrayList<InteractionContextElement>();
        for (InteractionContext context : this.contexts.values()) {
            InteractionContextElement info = (InteractionContextElement)context.parseEvent(event);
            nodes.add(info);
        }
        CompositeContextElement compositeNode = new CompositeContextElement(event.getStructureHandle(), nodes, this.contextScaling);
        return compositeNode;
    }

    @Override
    public IInteractionElement get(String handle) {
        if (this.contexts.values().size() == 0) {
            return null;
        }
        ArrayList<InteractionContextElement> nodes = new ArrayList<InteractionContextElement>();
        for (InteractionContext taskscape : this.contexts.values()) {
            InteractionContextElement node = (InteractionContextElement)taskscape.get(handle);
            if (node == null) continue;
            nodes.add(node);
        }
        CompositeContextElement composite = new CompositeContextElement(handle, nodes, this.contextScaling);
        return composite;
    }

    @Override
    public List<IInteractionElement> getLandmarks() {
        HashSet<IInteractionElement> landmarks = new HashSet<IInteractionElement>();
        for (InteractionContext taskscape : this.contexts.values()) {
            for (IInteractionElement concreteNode : taskscape.getLandmarks()) {
                if (concreteNode == null) continue;
                landmarks.add(this.get(concreteNode.getHandleIdentifier()));
            }
        }
        return new ArrayList<IInteractionElement>(landmarks);
    }

    @Override
    public List<IInteractionElement> getInteresting() {
        HashSet<IInteractionElement> landmarks = new HashSet<IInteractionElement>();
        for (InteractionContext context : this.contexts.values()) {
            for (IInteractionElement concreteNode : context.getInteresting()) {
                if (concreteNode == null) continue;
                landmarks.add(this.get(concreteNode.getHandleIdentifier()));
            }
        }
        return new ArrayList<IInteractionElement>(landmarks);
    }

    public void setActiveElement(IInteractionElement activeElement) {
        this.activeNode = activeElement;
    }

    @Override
    public IInteractionElement getActiveNode() {
        return this.activeNode;
    }

    @Override
    public void delete(IInteractionElement node) {
        for (InteractionContext taskscape : this.contexts.values()) {
            taskscape.delete(node);
        }
    }

    public void clear() {
        for (InteractionContext taskscape : this.contexts.values()) {
            taskscape.reset();
        }
    }

    public Map<String, InteractionContext> getContextMap() {
        return this.contexts;
    }

    @Override
    public List<IInteractionElement> getAllElements() {
        HashSet<IInteractionElement> nodes = new HashSet<IInteractionElement>();
        for (InteractionContext context : this.contexts.values()) {
            for (IInteractionElement concreteNode : context.getAllElements()) {
                nodes.add(this.get(concreteNode.getHandleIdentifier()));
            }
        }
        return new ArrayList<IInteractionElement>(nodes);
    }

    @Override
    public List<InteractionEvent> getInteractionHistory() {
        HashSet<InteractionEvent> events = new HashSet<InteractionEvent>();
        for (InteractionContext taskscape : this.contexts.values()) {
            events.addAll(taskscape.getInteractionHistory());
        }
        return new ArrayList<InteractionEvent>(events);
    }

    @Override
    public void updateElementHandle(IInteractionElement element, String newHandle) {
        for (InteractionContext context : this.contexts.values()) {
            context.updateElementHandle(element, newHandle);
        }
        element.setHandleIdentifier(newHandle);
    }

    @Override
    public String getHandleIdentifier() {
        if (this.contexts.values().size() == 1) {
            return this.contexts.keySet().iterator().next();
        }
        return null;
    }

    @Override
    public InteractionContextScaling getScaling() {
        return this.contextScaling;
    }

    @Override
    public String getContentLimitedTo() {
        return this.contentLimitedTo;
    }

    @Override
    public void setContentLimitedTo(String contentLimitedTo) {
        this.contentLimitedTo = contentLimitedTo;
    }
}

