/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.context.core.IDegreeOfInterest;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.CompositeDegreeOfInterest;
import org.eclipse.mylyn.internal.context.core.InteractionContextElement;
import org.eclipse.mylyn.internal.context.core.InteractionContextRelation;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.monitor.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeContextElement
implements IInteractionElement {
    private List<InteractionContextElement> nodes = null;
    private String handle = "<no handle>";
    private InteractionContextScaling contextScaling;

    public CompositeContextElement(String handle, List<InteractionContextElement> nodes, InteractionContextScaling contextScaling) {
        this.nodes = nodes;
        this.handle = handle;
        this.contextScaling = contextScaling;
    }

    @Override
    public IInteractionContext getContext() {
        IInteractionElement highestValueNode = null;
        for (IInteractionElement iInteractionElement : this.nodes) {
            if (highestValueNode != null && !(iInteractionElement.getInterest().getValue() < highestValueNode.getInterest().getValue())) continue;
            highestValueNode = iInteractionElement;
        }
        if (highestValueNode != null) {
            return highestValueNode.getContext();
        }
        return null;
    }

    @Override
    public IDegreeOfInterest getInterest() {
        if (this.nodes.size() == 1) {
            return this.nodes.iterator().next().getInterest();
        }
        CompositeDegreeOfInterest degreeOfInterest = new CompositeDegreeOfInterest(this.contextScaling);
        for (IInteractionElement iInteractionElement : this.nodes) {
            degreeOfInterest.getComposedDegreesOfInterest().add(iInteractionElement.getInterest());
        }
        return degreeOfInterest;
    }

    @Override
    public String getHandleIdentifier() {
        return this.handle;
    }

    @Override
    public void setHandleIdentifier(String handle) {
        this.handle = handle;
        for (IInteractionElement iInteractionElement : this.nodes) {
            iInteractionElement.setHandleIdentifier(handle);
        }
    }

    public List<InteractionContextElement> getNodes() {
        return this.nodes;
    }

    @Override
    public String getContentType() {
        HashSet<String> kinds = new HashSet<String>();
        String lastKind = null;
        for (IInteractionElement iInteractionElement : this.nodes) {
            lastKind = iInteractionElement.getContentType();
            kinds.add(lastKind);
        }
        if (kinds.size() == 1) {
            return lastKind;
        }
        return null;
    }

    @Override
    public InteractionContextRelation getRelation(String targetHandle) {
        HashSet<InteractionContextRelation> edges = new HashSet<InteractionContextRelation>();
        for (IInteractionElement iInteractionElement : this.nodes) {
            edges.add(iInteractionElement.getRelation(targetHandle));
        }
        if (edges.size() == 0) {
            return null;
        }
        if (edges.size() > 1) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.core", "Multiple edges found in composite, not supported"));
        }
        return (InteractionContextRelation)edges.iterator().next();
    }

    @Override
    public Collection<InteractionContextRelation> getRelations() {
        HashSet<InteractionContextRelation> edges = new HashSet<InteractionContextRelation>();
        for (InteractionContextElement node : this.nodes) {
            edges.addAll(node.getRelations());
        }
        return edges;
    }

    @Override
    public void clearRelations() {
        for (InteractionContextElement node : this.nodes) {
            node.clearRelations();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof CompositeContextElement) {
            CompositeContextElement element = (CompositeContextElement)object;
            return this.getHandleIdentifier().equals(element.getHandleIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        return "composite" + this.nodes;
    }
}

