/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.context.core.IContextStoreListener;

public abstract class AbstractContextStore {
    private List<IContextStoreListener> listeners = new ArrayList<IContextStoreListener>();

    public abstract void init();

    public abstract File getRootDirectory();

    public abstract File getContextDirectory();

    public void contextStoreMoved() {
        this.init();
        for (IContextStoreListener listener : this.listeners) {
            listener.contextStoreMoved();
        }
    }

    public void addListener(IContextStoreListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IContextStoreListener listener) {
        this.listeners.remove(listener);
    }
}

