/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.monitor.ui.MonitorUiPlugin;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;

public class MenuCommandMonitor
implements Listener {
    public static final String MENU_ITEM_ID = "item.label.";
    public static final String MENU_ITEM_SELECTED = "menu";
    public static final String TOOLBAR_ITEM_SELECTED = "toolbar";
    public static final String MENU_PATH_DELIM = "/";

    public void handleEvent(Event event) {
        try {
            if (!(event.widget instanceof Item)) {
                return;
            }
            Item item = (Item)event.widget;
            if (item.getData() == null) {
                return;
            }
            Object target = event.widget.getData();
            String id = null;
            String delta = null;
            if (target instanceof IContributionItem) {
                id = ((IContributionItem)target).getId();
            }
            if (id == null && target instanceof ActionContributionItem) {
                IAction action = ((ActionContributionItem)target).getAction();
                id = action.getId() != null ? action.getId() : action.getClass().getName();
            } else if (id == null) {
                id = target.getClass().getName();
            }
            if (item instanceof MenuItem) {
                MenuItem menu = (MenuItem)item;
                Menu parentMenu = menu.getParent();
                String location = "";
                if (parentMenu != null) {
                    while (parentMenu.getParentItem() != null) {
                        location = String.valueOf(parentMenu.getParentItem().getText()) + MENU_PATH_DELIM + location;
                        parentMenu = parentMenu.getParentMenu();
                    }
                }
                if (id == null) {
                    return;
                }
                delta = MENU_ITEM_SELECTED;
            } else if (item instanceof ToolItem) {
                delta = TOOLBAR_ITEM_SELECTED;
            }
            InteractionEvent interactionEvent = InteractionEvent.makeCommand((String)id, (String)delta);
            MonitorUiPlugin.getDefault().notifyInteractionObserved(interactionEvent);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.ui", "Could not log selection", t));
        }
    }
}

