/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.ui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.monitor.ui.AbstractUserInteractionMonitor;
import org.eclipse.mylyn.monitor.ui.MonitorUiPlugin;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.internal.browser.WebBrowserEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserMonitor
extends AbstractUserInteractionMonitor
implements IPartListener,
IWindowListener,
IPageListener {
    public static final String URL_LIST_DELIM = ",";
    private UrlTrackingListener urlTrackingListener = new UrlTrackingListener();
    private List<String> acceptedUrls = new ArrayList<String>();

    @Override
    protected void handleWorkbenchPartSelection(IWorkbenchPart part, ISelection selection, boolean contributeToContext) {
    }

    public void partOpened(IWorkbenchPart part) {
        Browser browser;
        if (part instanceof WebBrowserEditor && (browser = this.getBrowser((WebBrowserEditor)part)) != null) {
            browser.addLocationListener((LocationListener)this.urlTrackingListener);
        }
    }

    public void partClosed(IWorkbenchPart part) {
        Browser browser;
        if (part instanceof WebBrowserEditor && (browser = this.getBrowser((WebBrowserEditor)part)) != null && !browser.isDisposed()) {
            browser.removeLocationListener((LocationListener)this.urlTrackingListener);
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    private Browser getBrowser(WebBrowserEditor browserEditor) {
        try {
            Class<?> browserClass = browserEditor.getClass();
            Field browserField = browserClass.getDeclaredField("webBrowser");
            browserField.setAccessible(true);
            Object browserObject = browserField.get(browserEditor);
            if (browserObject != null && browserObject instanceof BrowserViewer) {
                return ((BrowserViewer)browserObject).getBrowser();
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.monitor.ui", "Could not add browser listener", (Throwable)e));
        }
        return null;
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.removePageListener((IPageListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.addPageListener((IPageListener)this);
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    public void pageClosed(IWorkbenchPage page) {
        page.removePartListener((IPartListener)this);
    }

    public void pageOpened(IWorkbenchPage page) {
        page.addPartListener((IPartListener)this);
    }

    public List<String> getAcceptedUrls() {
        return this.acceptedUrls;
    }

    public void setAcceptedUrls(String urlBuffer) {
        this.acceptedUrls = new ArrayList<String>();
        if (urlBuffer != null) {
            StringTokenizer token = new StringTokenizer(urlBuffer, URL_LIST_DELIM);
            while (token.hasMoreTokens()) {
                this.acceptedUrls.add(token.nextToken());
            }
        }
    }

    class UrlTrackingListener
    implements LocationListener {
        UrlTrackingListener() {
        }

        public void changing(LocationEvent event) {
        }

        public void changed(LocationEvent locationEvent) {
            String url = locationEvent.location;
            boolean accept = false;
            for (String urlMatch : BrowserMonitor.this.acceptedUrls) {
                if (url.indexOf(urlMatch) == -1) continue;
                accept = true;
            }
            if (accept) {
                InteractionEvent interactionEvent = new InteractionEvent(InteractionEvent.Kind.SELECTION, "url", url, "org.eclipse.ui.browser.editor", "null", "", 0.0f);
                MonitorUiPlugin.getDefault().notifyInteractionObserved(interactionEvent);
            }
        }
    }
}

