/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.AbstractAttributeMapper;
import org.eclipse.mylyn.internal.tasks.core.TaskDataManager;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;

public class TaskSelection {
    private final RepositoryTaskData taskData;

    public TaskSelection(RepositoryTaskData taskData) {
        if (taskData == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.taskData = (RepositoryTaskData)TaskDataManager.ObjectCloner.deepCopy(taskData);
            this.taskData.setAttributeFactory(taskData.getAttributeFactory());
            this.taskData.refresh();
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error creating a task data copy", (Throwable)e));
            throw new RuntimeException(e);
        }
    }

    public TaskSelection(AbstractTask task) {
        RepositoryTaskData taskData = new RepositoryTaskData(new IdentityAttributeFactory(), task.getConnectorKind(), task.getRepositoryUrl(), task.getTaskId(), task.getTaskKind());
        taskData.setSummary(task.getSummary());
        taskData.setAttributeValue("task.common.priority", task.getPriority());
        this.taskData = taskData;
    }

    public TaskSelection(String summary, String description) {
        RepositoryTaskData taskData = new RepositoryTaskData(new IdentityAttributeFactory(), "local", "local", "");
        taskData.setSummary(summary);
        taskData.setDescription(description);
        this.taskData = taskData;
    }

    public RepositoryTaskData getTaskData() {
        return this.taskData;
    }

    private class IdentityAttributeFactory
    extends AbstractAttributeFactory {
        private static final long serialVersionUID = 1L;
        private final AbstractAttributeMapper attributeMapper = new AbstractAttributeMapper(this){

            public String getType(RepositoryTaskAttribute taskAttribute) {
                return "shortText";
            }
        };

        private IdentityAttributeFactory() {
        }

        public AbstractAttributeMapper getAttributeMapper() {
            return this.attributeMapper;
        }

        public Date getDateForAttributeType(String attributeKey, String dateString) {
            return null;
        }

        public String getName(String key) {
            return null;
        }

        public boolean isHidden(String key) {
            return false;
        }

        public boolean isReadOnly(String key) {
            return false;
        }

        public String mapCommonAttributeKey(String key) {
            return key;
        }
    }
}

