/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskArchive;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.tasks.core.TaskContainerDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskList {
    private int lastLocalTaskId = 0;
    private Set<ITaskListChangeListener> changeListeners = new CopyOnWriteArraySet<ITaskListChangeListener>();
    private Map<String, UnmatchedTaskContainer> repositoryOrphansMap;
    private Map<String, AbstractTask> tasks;
    private Map<String, AbstractTaskCategory> categories;
    private Map<String, AbstractRepositoryQuery> queries;
    private List<AbstractTask> activeTasks;
    private TaskArchive archiveContainer;
    private UncategorizedTaskContainer defaultCategory;

    public TaskList() {
        this.reset();
    }

    private void addOrphan(AbstractTask task, Set<TaskContainerDelta> delta) {
        this.addOrphan(task, delta, 0);
    }

    private void addOrphan(AbstractTask task, Set<TaskContainerDelta> delta, int depth) {
        if (!task.getParentContainers().isEmpty()) {
            return;
        }
        if (task instanceof LocalTask) {
            this.moveTask(task, this.defaultCategory);
            return;
        }
        UnmatchedTaskContainer orphans = this.repositoryOrphansMap.get(task.getRepositoryUrl());
        if (orphans != null) {
            orphans.internalAddChild(task);
            if (delta != null) {
                delta.add(new TaskContainerDelta(orphans, TaskContainerDelta.Kind.CHANGED));
            }
            task.addParentContainer(orphans);
        }
        if (depth < 10 && !task.isEmpty()) {
            for (AbstractTask child : task.getChildren()) {
                this.addOrphan(child, delta, depth + 1);
            }
        }
    }

    private void removeOrphan(AbstractTask task, Set<TaskContainerDelta> delta) {
        this.removeOrphan(task, delta, 0);
    }

    private void removeOrphan(AbstractTask task, Set<TaskContainerDelta> delta, int depth) {
        UnmatchedTaskContainer orphans = this.repositoryOrphansMap.get(task.getRepositoryUrl());
        if (orphans != null) {
            if (orphans.contains(task.getHandleIdentifier())) {
                orphans.internalRemoveChild(task);
                if (delta != null) {
                    delta.add(new TaskContainerDelta(orphans, TaskContainerDelta.Kind.CHANGED));
                }
                if (depth < 10 && !task.isEmpty()) {
                    for (AbstractTask child : task.getChildren()) {
                        this.removeOrphan(child, delta, depth + 1);
                    }
                }
            }
            task.removeParentContainer(orphans);
        }
    }

    public Set<UnmatchedTaskContainer> getOrphanContainers() {
        return Collections.unmodifiableSet(new HashSet<UnmatchedTaskContainer>(this.repositoryOrphansMap.values()));
    }

    public UnmatchedTaskContainer getOrphanContainer(String repositoryUrl) {
        return this.repositoryOrphansMap.get(repositoryUrl);
    }

    public void addOrphanContainer(UnmatchedTaskContainer orphanedTasksContainer) {
        this.repositoryOrphansMap.put(orphanedTasksContainer.getRepositoryUrl(), orphanedTasksContainer);
    }

    public void removeOrphanContainer(String url) {
        if (url != null && !url.equals("local")) {
            this.repositoryOrphansMap.remove(url);
        }
    }

    public void reset() {
        this.tasks = new ConcurrentHashMap<String, AbstractTask>();
        this.repositoryOrphansMap = new ConcurrentHashMap<String, UnmatchedTaskContainer>();
        this.categories = new ConcurrentHashMap<String, AbstractTaskCategory>();
        this.queries = new ConcurrentHashMap<String, AbstractRepositoryQuery>();
        this.archiveContainer = new TaskArchive(this);
        this.defaultCategory = new UncategorizedTaskContainer();
        this.activeTasks = new CopyOnWriteArrayList<AbstractTask>();
        this.lastLocalTaskId = 0;
        this.categories.put(this.defaultCategory.getHandleIdentifier(), this.defaultCategory);
    }

    public void addTask(AbstractTask task) throws IllegalArgumentException {
        this.addTask(task, null);
    }

    public Set<AbstractTask> getTasks(Set<String> handles) {
        HashSet<AbstractTask> result = new HashSet<AbstractTask>();
        Map<String, AbstractTask> tempTasks = Collections.unmodifiableMap(this.tasks);
        for (String handle : handles) {
            AbstractTask tempTask = tempTasks.get(handle);
            if (tempTask == null) continue;
            result.add(tempTask);
        }
        return result;
    }

    public void addTask(AbstractTask task, AbstractTaskContainer parentContainer) throws IllegalArgumentException {
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        AbstractTask newTask = this.tasks.get(task.getHandleIdentifier());
        if (newTask == null) {
            newTask = task;
            this.tasks.put(newTask.getHandleIdentifier(), newTask);
            HashSet<TaskContainerDelta> delta = new HashSet<TaskContainerDelta>();
            delta.add(new TaskContainerDelta(newTask, TaskContainerDelta.Kind.ADDED));
            if (parentContainer != null) {
                delta.add(new TaskContainerDelta(parentContainer, TaskContainerDelta.Kind.CHANGED));
            }
            for (ITaskListChangeListener listener : this.changeListeners) {
                listener.containersChanged(delta);
            }
        }
        if (parentContainer != null) {
            if (parentContainer instanceof AbstractTask) {
                this.tasks.put(parentContainer.getHandleIdentifier(), (AbstractTask)parentContainer);
                this.addOrphan((AbstractTask)parentContainer, null);
            }
            if (parentContainer instanceof AbstractTaskCategory) {
                this.removeFromCategory(TaskCategory.getParentTaskCategory(newTask), newTask);
            }
            this.removeOrphan(newTask, null);
            newTask.addParentContainer(parentContainer);
            parentContainer.internalAddChild(newTask);
        } else {
            this.addOrphan(task, null);
        }
    }

    public void moveTask(AbstractTask task, AbstractTaskContainer container) {
        if (!this.tasks.containsKey(task.getHandleIdentifier())) {
            this.tasks.put(task.getHandleIdentifier(), task);
        }
        HashSet<TaskContainerDelta> delta = new HashSet<TaskContainerDelta>();
        delta.add(new TaskContainerDelta(container, TaskContainerDelta.Kind.CHANGED));
        AbstractTaskCategory category = TaskCategory.getParentTaskCategory(task);
        if (category != null) {
            task.removeParentContainer(category);
            category.internalRemoveChild(task);
            delta.add(new TaskContainerDelta(category, TaskContainerDelta.Kind.CHANGED));
        }
        if (container != null) {
            this.addTask(task, container);
            delta.add(new TaskContainerDelta(container, TaskContainerDelta.Kind.CHANGED));
            if (!(container instanceof UnmatchedTaskContainer)) {
                this.removeOrphan(task, delta);
            }
        } else {
            this.addTask(task, null);
        }
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containersChanged(delta);
        }
    }

    public void moveToContainer(AbstractTask task, AbstractTaskCategory container) {
        if (!this.tasks.containsKey(task.getHandleIdentifier())) {
            this.tasks.put(task.getHandleIdentifier(), task);
        }
        HashSet<TaskContainerDelta> delta = new HashSet<TaskContainerDelta>();
        delta.add(new TaskContainerDelta(container, TaskContainerDelta.Kind.CHANGED));
        Set<AbstractTaskContainer> currentContainers = task.getParentContainers();
        for (AbstractTaskContainer taskContainer : currentContainers) {
            if (!(taskContainer instanceof AbstractTaskCategory)) continue;
            if (!(taskContainer instanceof UnmatchedTaskContainer)) {
                taskContainer.internalRemoveChild(task);
            }
            task.removeParentContainer(taskContainer);
            delta.add(new TaskContainerDelta(taskContainer, TaskContainerDelta.Kind.CHANGED));
        }
        if (container != null) {
            this.internalAddTask(task, container);
            delta.add(new TaskContainerDelta(container, TaskContainerDelta.Kind.CHANGED));
            if (!(container instanceof UnmatchedTaskContainer)) {
                this.removeOrphan(task, delta);
            }
        } else {
            this.internalAddTask(task, null);
        }
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containersChanged(delta);
        }
    }

    public void refactorRepositoryUrl(String oldRepositoryUrl, String newRepositoryUrl) {
        for (AbstractTask task : this.tasks.values()) {
            if (!oldRepositoryUrl.equals(RepositoryTaskHandleUtil.getRepositoryUrl(task.getHandleIdentifier()))) continue;
            this.tasks.remove(task.getHandleIdentifier());
            task.setRepositoryUrl(newRepositoryUrl);
            this.tasks.put(task.getHandleIdentifier(), task);
            String taskUrl = task.getUrl();
            if (taskUrl == null || !taskUrl.startsWith(oldRepositoryUrl)) continue;
            task.setUrl(String.valueOf(newRepositoryUrl) + taskUrl.substring(oldRepositoryUrl.length()));
        }
        HashSet<TaskContainerDelta> delta = new HashSet<TaskContainerDelta>();
        for (AbstractRepositoryQuery query : this.queries.values()) {
            if (!query.getRepositoryUrl().equals(oldRepositoryUrl)) continue;
            query.setRepositoryUrl(newRepositoryUrl);
            delta.add(new TaskContainerDelta(query, TaskContainerDelta.Kind.CHANGED));
        }
        for (UnmatchedTaskContainer orphans : this.repositoryOrphansMap.values()) {
            if (!orphans.getRepositoryUrl().equals(oldRepositoryUrl)) continue;
            this.repositoryOrphansMap.remove(oldRepositoryUrl);
            orphans.setRepositoryUrl(newRepositoryUrl);
            this.repositoryOrphansMap.put(newRepositoryUrl, orphans);
            delta.add(new TaskContainerDelta(orphans, TaskContainerDelta.Kind.CHANGED));
        }
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containersChanged(delta);
        }
    }

    public void addCategory(TaskCategory category) throws IllegalArgumentException {
        if (category == null) {
            throw new IllegalArgumentException("Category cannot be null");
        }
        this.categories.put(category.getHandleIdentifier(), category);
        HashSet<TaskContainerDelta> delta = new HashSet<TaskContainerDelta>();
        delta.add(new TaskContainerDelta(category, TaskContainerDelta.Kind.ADDED));
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containersChanged(delta);
        }
    }

    public void removeFromCategory(TaskCategory category, AbstractTask task) {
        this.removeFromCategory((AbstractTaskCategory)category, task);
    }

    public void removeFromCategory(AbstractTaskCategory category, AbstractTask task) {
        if (category == null || task == null) {
            return;
        }
        HashSet<TaskContainerDelta> delta = new HashSet<TaskContainerDelta>();
        category.internalRemoveChild(task);
        task.removeParentContainer(category);
        this.addOrphan(task, delta);
        delta.add(new TaskContainerDelta(category, TaskContainerDelta.Kind.CHANGED));
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containersChanged(delta);
        }
    }

    public void removeFromQuery(AbstractRepositoryQuery query, AbstractTask task) {
        HashSet<TaskContainerDelta> delta = new HashSet<TaskContainerDelta>();
        delta.add(new TaskContainerDelta(task, TaskContainerDelta.Kind.CHANGED));
        query.internalRemoveChild(task);
        task.removeParentContainer(query);
        this.addOrphan(task, delta);
    }

    public void renameTask(AbstractTask task, String description) {
        task.setSummary(description);
        HashSet<TaskContainerDelta> delta = new HashSet<TaskContainerDelta>();
        delta.add(new TaskContainerDelta(task, TaskContainerDelta.Kind.CHANGED));
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containersChanged(delta);
        }
    }

    public void renameContainer(AbstractTaskContainer container, String newDescription) {
        if (container instanceof AbstractTask) {
            return;
        }
        if (!(container instanceof TaskArchive) && !(container instanceof UnmatchedTaskContainer)) {
            if (this.queries.remove(container.getHandleIdentifier()) != null) {
                if (container instanceof AbstractTaskCategory) {
                    ((AbstractTaskCategory)container).setHandleIdentifier(newDescription);
                } else if (container instanceof AbstractRepositoryQuery) {
                    ((AbstractRepositoryQuery)container).setHandleIdentifier(newDescription);
                    this.queries.put(((AbstractRepositoryQuery)container).getHandleIdentifier(), (AbstractRepositoryQuery)container);
                }
            } else if (container instanceof TaskCategory && this.categories.remove(container.getHandleIdentifier()) != null) {
                ((TaskCategory)container).setHandleIdentifier(newDescription);
                this.categories.put(((TaskCategory)container).getHandleIdentifier(), (TaskCategory)container);
            }
        }
        HashSet<TaskContainerDelta> delta = new HashSet<TaskContainerDelta>();
        delta.add(new TaskContainerDelta(container, TaskContainerDelta.Kind.REMOVED));
        delta.add(new TaskContainerDelta(container, TaskContainerDelta.Kind.ADDED));
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containersChanged(delta);
        }
    }

    public void addQuery(AbstractRepositoryQuery query) throws IllegalArgumentException {
        if (query == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        this.queries.put(query.getHandleIdentifier(), query);
        HashSet<TaskContainerDelta> delta = new HashSet<TaskContainerDelta>();
        delta.add(new TaskContainerDelta(query, TaskContainerDelta.Kind.ADDED));
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containersChanged(delta);
        }
    }

    public void deleteTask(AbstractTask task) {
        HashSet<TaskContainerDelta> delta = new HashSet<TaskContainerDelta>();
        for (AbstractTaskContainer container : task.getParentContainers()) {
            container.internalRemoveChild(task);
            task.removeParentContainer(container);
        }
        for (AbstractTask child : task.getChildren()) {
            child.removeParentContainer(task);
            this.addOrphan(child, delta);
        }
        task.clear();
        this.removeOrphan(task, delta);
        this.tasks.remove(task.getHandleIdentifier());
        delta.add(new TaskContainerDelta(task, TaskContainerDelta.Kind.REMOVED));
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containersChanged(delta);
        }
    }

    public void deleteCategory(AbstractTaskCategory category) {
        HashSet<TaskContainerDelta> delta = new HashSet<TaskContainerDelta>();
        this.categories.remove(category.getHandleIdentifier());
        for (AbstractTask task : category.getChildren()) {
            task.removeParentContainer(category);
            this.addOrphan(task, delta);
        }
        delta.add(new TaskContainerDelta(category, TaskContainerDelta.Kind.REMOVED));
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containersChanged(delta);
        }
    }

    public void deleteQuery(AbstractRepositoryQuery query) {
        HashSet<TaskContainerDelta> delta = new HashSet<TaskContainerDelta>();
        this.queries.remove(query.getHandleIdentifier());
        for (AbstractTask task : query.getChildren()) {
            task.removeParentContainer(query);
            this.addOrphan(task, delta);
        }
        delta.add(new TaskContainerDelta(query, TaskContainerDelta.Kind.REMOVED));
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containersChanged(delta);
        }
    }

    public void markComplete(AbstractTask task, boolean complete) {
        task.setCompleted(complete);
        HashSet<TaskContainerDelta> delta = new HashSet<TaskContainerDelta>();
        delta.add(new TaskContainerDelta(task, TaskContainerDelta.Kind.CHANGED));
        for (ITaskListChangeListener listener : new ArrayList<ITaskListChangeListener>(this.changeListeners)) {
            listener.containersChanged(delta);
        }
    }

    public void addChangeListener(ITaskListChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ITaskListChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void internalAddCategory(TaskCategory category) {
        this.categories.put(category.getHandleIdentifier(), category);
    }

    public void internalAddTask(AbstractTask task, AbstractTaskCategory container) {
        this.internalAddTask(task, (AbstractTaskContainer)container);
    }

    private void internalAddTask(AbstractTask task, AbstractTaskContainer container) {
        this.tasks.put(task.getHandleIdentifier(), task);
        if (container != null) {
            container.internalAddChild(task);
            if (container instanceof TaskCategory || container instanceof UnmatchedTaskContainer || container instanceof UncategorizedTaskContainer) {
                task.addParentContainer(container);
            }
        } else {
            this.addOrphan(task, null);
        }
    }

    public void internalAddRootTask(AbstractTask task) {
        this.internalAddTask(task, null);
    }

    public void internalAddQuery(AbstractRepositoryQuery query) {
        this.queries.put(query.getHandleIdentifier(), query);
    }

    public void setActive(AbstractTask task, boolean active) {
        task.setActive(active);
        if (active && !this.activeTasks.contains(task)) {
            this.activeTasks.add(task);
        } else if (!active) {
            this.activeTasks.remove(task);
        }
    }

    public List<AbstractTask> getActiveTasks() {
        return this.activeTasks;
    }

    public AbstractTask getActiveTask() {
        if (this.activeTasks.size() > 0) {
            return this.activeTasks.get(0);
        }
        return null;
    }

    public Set<AbstractTaskCategory> getCategories() {
        return Collections.unmodifiableSet(new HashSet<AbstractTaskCategory>(this.categories.values()));
    }

    public List<AbstractTaskCategory> getUserCategories() {
        ArrayList<AbstractTaskCategory> included = new ArrayList<AbstractTaskCategory>();
        for (AbstractTaskCategory category : this.categories.values()) {
            included.add(category);
        }
        return included;
    }

    public Set<AbstractRepositoryQuery> getQueries() {
        return Collections.unmodifiableSet(new HashSet<AbstractRepositoryQuery>(this.queries.values()));
    }

    public Set<AbstractTaskContainer> getRootElements() {
        HashSet<AbstractTaskContainer> roots = new HashSet<AbstractTaskContainer>();
        roots.add(this.defaultCategory);
        for (AbstractTaskCategory cat : this.categories.values()) {
            roots.add(cat);
        }
        for (AbstractRepositoryQuery query : this.queries.values()) {
            roots.add(query);
        }
        for (UnmatchedTaskContainer orphanContainer : this.repositoryOrphansMap.values()) {
            roots.add(orphanContainer);
        }
        return roots;
    }

    public Collection<AbstractTask> getAllTasks() {
        return Collections.unmodifiableCollection(this.tasks.values());
    }

    public Set<AbstractTaskCategory> getTaskContainers() {
        HashSet<AbstractTaskCategory> containers = new HashSet<AbstractTaskCategory>();
        for (AbstractTaskCategory container : this.categories.values()) {
            if (!(container instanceof TaskCategory) && !(container instanceof TaskArchive)) continue;
            containers.add(container);
        }
        return containers;
    }

    public AbstractRepositoryQuery getQueryForHandle(String handle) {
        if (handle == null) {
            return null;
        }
        for (AbstractRepositoryQuery query : this.queries.values()) {
            if (!query.contains(handle)) continue;
            return query;
        }
        return null;
    }

    public boolean isEmpty() {
        boolean isEmpty;
        boolean bl = isEmpty = this.getCategories().size() == 1 && this.getCategories().contains(this.defaultCategory);
        return this.getAllTasks().size() == 0 && isEmpty && this.getQueries().size() == 0;
    }

    public AbstractTask getTask(String handleIdentifier) {
        if (handleIdentifier == null) {
            return null;
        }
        return this.tasks.get(handleIdentifier);
    }

    public AbstractTask getTask(String repositoryUrl, String taskId) {
        if (!RepositoryTaskHandleUtil.isValidTaskId(taskId)) {
            return null;
        }
        String handle = RepositoryTaskHandleUtil.getHandle(repositoryUrl, taskId);
        AbstractTask task = this.getTask(handle);
        return task;
    }

    public AbstractTask getRepositoryTask(String taskUrl) {
        for (AbstractTask currTask : this.tasks.values()) {
            String currUrl = currTask.getUrl();
            if (currUrl == null || currUrl.equals("") || !currUrl.equals(taskUrl)) continue;
            return currTask;
        }
        return null;
    }

    public AbstractTask getTaskByKey(String repositoryUrl, String taskKey) {
        for (AbstractTask task : this.tasks.values()) {
            String currentTaskKey = task.getTaskKey();
            if (currentTaskKey == null || !currentTaskKey.equals(taskKey) || !task.getRepositoryUrl().equals(repositoryUrl)) continue;
            return task;
        }
        return null;
    }

    public AbstractTaskCategory getContainerForHandle(String categoryHandle) {
        for (AbstractTaskCategory cat : this.categories.values()) {
            if (cat == null || !cat.getHandleIdentifier().equals(categoryHandle)) continue;
            return cat;
        }
        return null;
    }

    public AbstractTaskCategory getDefaultCategory() {
        return this.defaultCategory;
    }

    public TaskArchive getArchiveContainer() {
        return this.archiveContainer;
    }

    public Set<AbstractRepositoryQuery> getParentQueries(AbstractTask task) {
        HashSet<AbstractRepositoryQuery> parentQueries = new HashSet<AbstractRepositoryQuery>();
        for (AbstractTaskContainer container : task.getParentContainers()) {
            if (!(container instanceof AbstractRepositoryQuery)) continue;
            parentQueries.add((AbstractRepositoryQuery)container);
        }
        return parentQueries;
    }

    public Set<AbstractRepositoryQuery> getQueriesForHandle(String handle) {
        if (handle == null) {
            return Collections.emptySet();
        }
        Set<AbstractRepositoryQuery> queriesForHandle = new HashSet<AbstractRepositoryQuery>();
        AbstractTask tempTask = this.tasks.get(handle);
        if (tempTask != null) {
            queriesForHandle = this.getParentQueries(tempTask);
        }
        return queriesForHandle;
    }

    public Set<AbstractRepositoryQuery> getRepositoryQueries(String repositoryUrl) {
        HashSet<AbstractRepositoryQuery> repositoryQueries = new HashSet<AbstractRepositoryQuery>();
        if (repositoryUrl != null) {
            for (AbstractRepositoryQuery query : this.queries.values()) {
                if (!query.getRepositoryUrl().equals(repositoryUrl)) continue;
                repositoryQueries.add(query);
            }
        }
        return repositoryQueries;
    }

    public Set<AbstractTask> getRepositoryTasks(String repositoryUrl) {
        HashSet<AbstractTask> repositoryTasks = new HashSet<AbstractTask>();
        if (repositoryUrl != null) {
            for (AbstractTask task : this.tasks.values()) {
                if (!task.getRepositoryUrl().equals(repositoryUrl)) continue;
                repositoryTasks.add(task);
            }
        }
        return repositoryTasks;
    }

    public Set<ITaskListChangeListener> getChangeListeners() {
        return Collections.unmodifiableSet(this.changeListeners);
    }

    public void notifyTaskChanged(AbstractTask task, boolean content) {
        for (ITaskListChangeListener listener : new ArrayList<ITaskListChangeListener>(this.changeListeners)) {
            try {
                HashSet<TaskContainerDelta> delta = new HashSet<TaskContainerDelta>();
                TaskContainerDelta.Kind kind = content ? TaskContainerDelta.Kind.CONTENT : TaskContainerDelta.Kind.CHANGED;
                delta.add(new TaskContainerDelta(task, kind));
                listener.containersChanged(delta);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Notification failed for: " + listener, t));
            }
        }
    }

    public void notifyContainersUpdated(Set<? extends AbstractTaskContainer> containers) {
        HashSet<TaskContainerDelta> delta;
        if (containers == null) {
            delta = new HashSet<TaskContainerDelta>();
            delta.add(new TaskContainerDelta(null, TaskContainerDelta.Kind.ROOT));
        } else {
            delta = new HashSet();
            for (AbstractTaskContainer abstractTaskContainer : containers) {
                delta.add(new TaskContainerDelta(abstractTaskContainer, TaskContainerDelta.Kind.CHANGED));
            }
        }
        for (ITaskListChangeListener iTaskListChangeListener : new ArrayList<ITaskListChangeListener>(this.changeListeners)) {
            try {
                iTaskListChangeListener.containersChanged(delta);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Notification failed for: " + iTaskListChangeListener, t));
            }
        }
    }

    public int getNextLocalTaskId() {
        return ++this.lastLocalTaskId;
    }

    public void setLastLocalTaskId(int lastTaskNum) {
        this.lastLocalTaskId = lastTaskNum;
    }

    public int getLastLocalTaskId() {
        return this.lastLocalTaskId;
    }

    public int findLargestTaskId() {
        int max = 0;
        max = Math.max(this.largestTaskIdHelper(this.tasks.values(), 0, 0), max);
        for (AbstractTaskCategory cat : this.getTaskContainers()) {
            max = Math.max(this.largestTaskIdHelper(cat.getChildren(), 0, 0), max);
        }
        return max;
    }

    private int largestTaskIdHelper(Collection<AbstractTask> tasks, int lastMax, int depth) {
        if (depth >= 20) {
            return lastMax;
        }
        ++depth;
        int ihandle = 0;
        int max = 0;
        for (AbstractTask task : tasks) {
            if (!(task instanceof LocalTask)) continue;
            String string = task.getHandleIdentifier().substring(task.getHandleIdentifier().lastIndexOf(45) + 1, task.getHandleIdentifier().length());
            try {
                ihandle = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
            max = Math.max(ihandle, max);
            ihandle = this.largestTaskIdHelper(task.getChildren(), max, depth);
            max = Math.max(ihandle, max);
        }
        return max;
    }

    public final void insertTask(AbstractTask task, AbstractTaskCategory legacyCategory, AbstractTask parent) {
        if (task.getCategoryHandle().length() > 0) {
            AbstractTaskCategory category = this.getContainerForHandle(task.getCategoryHandle());
            if (category != null) {
                this.internalAddTask(task, category);
            } else if (parent == null) {
                this.internalAddRootTask(task);
            }
        } else if (legacyCategory != null && !(legacyCategory instanceof TaskArchive) && this.getCategories().contains(legacyCategory)) {
            task.addParentContainer(legacyCategory);
            legacyCategory.internalAddChild(task);
        } else {
            this.internalAddTask(task, null);
        }
        this.setActive(task, task.isActive());
    }
}

