/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeContainer
implements Serializable {
    public static final String ERROR_NO_ATTRIBUTE_FACTORY = "Attribute factory not available.";
    private static final long serialVersionUID = 3538078709450471836L;
    private final ArrayList<String> attributeKeys;
    private final HashMap<String, RepositoryTaskAttribute> attributes;
    private transient AbstractAttributeFactory attributeFactory;
    private transient RepositoryTaskData taskData;

    public AttributeContainer(AbstractAttributeFactory attributeFactory) {
        this.attributeFactory = attributeFactory;
        this.attributeKeys = new ArrayList();
        this.attributes = new HashMap();
    }

    public void setAttributeFactory(AbstractAttributeFactory factory) {
        this.attributeFactory = factory;
    }

    public void addAttribute(String key, RepositoryTaskAttribute attribute) {
        if (this.attributeFactory == null) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", ERROR_NO_ATTRIBUTE_FACTORY));
            return;
        }
        String mapped = this.attributeFactory.mapCommonAttributeKey(key);
        if (mapped == null) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Mapped value for " + key + " returned null."));
            return;
        }
        if (!this.attributes.containsKey(mapped)) {
            this.attributeKeys.add(mapped);
        }
        this.attributes.put(mapped, attribute);
    }

    public RepositoryTaskAttribute getAttribute(String key) {
        if (this.attributeFactory == null) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", ERROR_NO_ATTRIBUTE_FACTORY));
            return null;
        }
        String mapped = this.attributeFactory.mapCommonAttributeKey(key);
        return this.attributes.get(mapped);
    }

    public void removeAttribute(Object key) {
        this.attributeKeys.remove(key);
        this.attributes.remove(key);
    }

    public List<RepositoryTaskAttribute> getAttributes() {
        ArrayList<RepositoryTaskAttribute> attributeEntries = new ArrayList<RepositoryTaskAttribute>(this.attributeKeys.size());
        for (String key : this.attributeKeys) {
            RepositoryTaskAttribute attribute = this.attributes.get(key);
            attributeEntries.add(attribute);
        }
        return attributeEntries;
    }

    public void removeAllAttributes() {
        this.attributeKeys.clear();
        this.attributes.clear();
    }

    public void addAttributeValue(String key, String value) {
        if (this.attributeFactory == null) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", ERROR_NO_ATTRIBUTE_FACTORY));
            return;
        }
        RepositoryTaskAttribute attrib = this.getAttribute(key);
        if (attrib != null) {
            attrib.addValue(value);
        } else {
            attrib = this.attributeFactory.createAttribute(key);
            attrib.addValue(value);
            this.addAttribute(key, attrib);
        }
    }

    public void setAttributeValue(String key, String value) {
        if (this.attributeFactory == null) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", ERROR_NO_ATTRIBUTE_FACTORY));
            return;
        }
        RepositoryTaskAttribute attrib = this.getAttribute(key);
        if (attrib == null) {
            attrib = this.attributeFactory.createAttribute(key);
            this.addAttribute(key, attrib);
        }
        attrib.setValue(value);
    }

    public String getAttributeValue(String key) {
        if (this.attributeFactory == null) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", ERROR_NO_ATTRIBUTE_FACTORY));
            return "";
        }
        String returnValue = "";
        RepositoryTaskAttribute attrib = this.getAttribute(key);
        if (attrib != null) {
            returnValue = attrib.getValue();
        }
        return returnValue;
    }

    public List<String> getAttributeValues(String key) {
        List<String> returnValue = new ArrayList<String>();
        if (this.attributeFactory == null) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", ERROR_NO_ATTRIBUTE_FACTORY));
            return returnValue;
        }
        RepositoryTaskAttribute attrib = this.getAttribute(key);
        if (attrib != null) {
            returnValue = attrib.getValues();
        }
        return returnValue;
    }

    public AbstractAttributeFactory getAttributeFactory() {
        return this.attributeFactory;
    }

    void setTaskData(RepositoryTaskData taskData) {
        this.taskData = taskData;
        for (RepositoryTaskAttribute attribute : this.attributes.values()) {
            attribute.setTaskData(taskData);
        }
    }

    public RepositoryTaskData getTaskData() {
        return this.taskData;
    }
}

