/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTaskDataHandler {
    public abstract RepositoryTaskData getTaskData(TaskRepository var1, String var2, IProgressMonitor var3) throws CoreException;

    public Set<RepositoryTaskData> getMultiTaskData(TaskRepository repository, Set<String> taskIds, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public abstract String postTaskData(TaskRepository var1, RepositoryTaskData var2, IProgressMonitor var3) throws CoreException;

    public abstract AbstractAttributeFactory getAttributeFactory(String var1, String var2, String var3);

    public abstract boolean initializeTaskData(TaskRepository var1, RepositoryTaskData var2, IProgressMonitor var3) throws CoreException;

    public boolean initializeSubTaskData(TaskRepository repository, RepositoryTaskData taskData, RepositoryTaskData parentTaskData, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public boolean canInitializeSubTaskData(AbstractTask task, RepositoryTaskData parentTaskData) {
        return false;
    }

    public abstract AbstractAttributeFactory getAttributeFactory(RepositoryTaskData var1);

    public Set<String> getSubTaskIds(RepositoryTaskData taskData) {
        return Collections.emptySet();
    }

    public boolean canGetMultiTaskData() {
        return false;
    }

    public void cloneTaskData(RepositoryTaskData sourceTaskData, RepositoryTaskData targetTaskData) {
        targetTaskData.setSummary(sourceTaskData.getSummary());
        targetTaskData.setDescription(sourceTaskData.getDescription());
        if (sourceTaskData.getRepositoryKind().equals(targetTaskData.getRepositoryKind()) && sourceTaskData.getTaskKind().equals(targetTaskData.getTaskKind())) {
            for (RepositoryTaskAttribute sourceAttribute : sourceTaskData.getAttributes()) {
                this.copyAttributeValue(sourceAttribute, targetTaskData.getAttribute(sourceAttribute.getId()));
            }
        } else {
            String[] commonAttributeKeys;
            String[] stringArray = commonAttributeKeys = new String[]{"task.common.keywords", "task.common.priority", "task.common.product", "task.common.component", "task.common.resolution", "task.common.user.assigned", "task.common.user.cc"};
            int n = commonAttributeKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                RepositoryTaskAttribute sourceAttribute = sourceTaskData.getAttribute(key);
                if (sourceAttribute != null) {
                    this.copyAttributeValue(sourceAttribute, targetTaskData.getAttribute(key));
                }
                ++n2;
            }
        }
    }

    private void copyAttributeValue(RepositoryTaskAttribute sourceAttribute, RepositoryTaskAttribute targetAttribute) {
        block5: {
            if (targetAttribute == null) {
                return;
            }
            if (sourceAttribute.isReadOnly() || sourceAttribute.isHidden() || targetAttribute.isHidden() || targetAttribute.isReadOnly()) break block5;
            targetAttribute.clearValues();
            if (targetAttribute.getOptions().size() > 0) {
                List<String> values = sourceAttribute.getValues();
                for (String value : values) {
                    if (!targetAttribute.getOptions().contains(value)) continue;
                    targetAttribute.addValue(value);
                }
            } else {
                List<String> values = sourceAttribute.getValues();
                for (String value : values) {
                    targetAttribute.addValue(value);
                }
            }
        }
    }
}

