/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.TaskDataManager;
import org.eclipse.mylyn.tasks.core.AbstractAttachmentHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.ITaskCollector;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryConnector {
    protected Set<RepositoryTemplate> templates = new LinkedHashSet<RepositoryTemplate>();
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    protected TaskList taskList;
    private boolean userManaged = true;
    private TaskDataManager taskDataManager;

    public void init(TaskList taskList) {
        this.taskList = taskList;
    }

    public void setTaskDataManager(TaskDataManager taskDataManager) {
        this.taskDataManager = taskDataManager;
        AbstractAttachmentHandler handler = this.getAttachmentHandler();
        if (handler != null) {
            handler.setTaskDataManager(taskDataManager);
        }
    }

    public abstract AbstractAttachmentHandler getAttachmentHandler();

    public abstract AbstractTaskDataHandler getTaskDataHandler();

    public abstract String getRepositoryUrlFromTaskUrl(String var1);

    public abstract String getTaskIdFromTaskUrl(String var1);

    public abstract String getTaskUrl(String var1, String var2);

    public String[] getTaskIdsFromComment(TaskRepository repository, String comment) {
        return null;
    }

    public abstract boolean canCreateTaskFromKey(TaskRepository var1);

    public abstract boolean canCreateNewTask(TaskRepository var1);

    public AbstractTask createTaskFromExistingId(TaskRepository repository, String id, IProgressMonitor monitor) throws CoreException {
        return this.createTaskFromExistingId(repository, id, true, monitor);
    }

    public AbstractTask createTaskFromExistingId(TaskRepository repository, String id, boolean retrieveSubTasks, IProgressMonitor monitor) throws CoreException {
        AbstractTask repositoryTask = this.taskList.getTask(repository.getUrl(), id);
        if (repositoryTask == null && this.getTaskDataHandler() != null) {
            RepositoryTaskData taskData = null;
            taskData = this.getTaskDataHandler().getTaskData(repository, id, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (taskData != null && (repositoryTask = this.createTaskFromTaskData(repository, taskData, retrieveSubTasks, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null) {
                repositoryTask.setSynchronizationState(AbstractTask.RepositoryTaskSyncState.INCOMING);
                this.taskList.addTask(repositoryTask);
            }
        }
        return repositoryTask;
    }

    public AbstractTask createTaskFromTaskData(TaskRepository repository, RepositoryTaskData taskData, boolean retrieveSubTasks, IProgressMonitor monitor) throws CoreException {
        AbstractTask repositoryTask = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            if (taskData != null && this.getTaskDataManager() != null) {
                repositoryTask = this.createTask(repository.getUrl(), taskData.getId(), String.valueOf(taskData.getId()) + ": " + taskData.getDescription());
                this.updateTaskFromTaskData(repository, repositoryTask, taskData);
                this.getTaskDataManager().setNewTaskData(taskData);
                if (retrieveSubTasks) {
                    monitor.beginTask("Creating task", this.getTaskDataHandler().getSubTaskIds(taskData).size());
                    for (String subId : this.getTaskDataHandler().getSubTaskIds(taskData)) {
                        AbstractTask subTask;
                        if (subId == null || subId.trim().equals("") || (subTask = this.createTaskFromExistingId(repository, subId, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) == null) continue;
                        this.taskList.addTask(subTask, repositoryTask);
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
        return repositoryTask;
    }

    public abstract AbstractTask createTask(String var1, String var2, String var3);

    public abstract IStatus performQuery(AbstractRepositoryQuery var1, TaskRepository var2, IProgressMonitor var3, ITaskCollector var4);

    public abstract String getLabel();

    public String getShortLabel() {
        String label = this.getLabel();
        if (label == null) {
            return null;
        }
        int i = label.indexOf("(");
        if (i != -1) {
            return label.substring(0, i).trim();
        }
        i = label.indexOf(" ");
        if (i != -1) {
            return label.substring(0, i).trim();
        }
        return label;
    }

    public abstract String getConnectorKind();

    public abstract void updateTaskFromRepository(TaskRepository var1, AbstractTask var2, IProgressMonitor var3) throws CoreException;

    public abstract void updateTaskFromTaskData(TaskRepository var1, AbstractTask var2, RepositoryTaskData var3);

    public boolean updateTaskFromQueryHit(TaskRepository repository, AbstractTask existingTask, AbstractTask queryHit) {
        boolean changed = false;
        if (existingTask.isCompleted() != queryHit.isCompleted()) {
            existingTask.setCompleted(queryHit.isCompleted());
            changed = true;
        }
        if (this.hasTaskPropertyChanged(existingTask.getSummary(), queryHit.getSummary())) {
            existingTask.setSummary(queryHit.getSummary());
            changed = true;
        }
        if (this.hasTaskPropertyChanged(existingTask.getDueDate(), queryHit.getDueDate())) {
            existingTask.setDueDate(queryHit.getDueDate());
            changed = true;
        }
        if (this.hasTaskPropertyChanged(existingTask.getOwner(), queryHit.getOwner())) {
            existingTask.setOwner(queryHit.getOwner());
            changed = true;
        }
        if (this.hasTaskPropertyChanged(existingTask.getPriority(), queryHit.getPriority())) {
            existingTask.setPriority(queryHit.getPriority());
            changed = true;
        }
        if (this.hasTaskPropertyChanged(existingTask.getUrl(), queryHit.getUrl())) {
            existingTask.setUrl(queryHit.getUrl());
            changed = true;
        }
        return changed;
    }

    protected final boolean hasTaskPropertyChanged(Object existingProperty, Object newProperty) {
        if (newProperty == null) {
            return false;
        }
        return existingProperty == null ? true : !existingProperty.equals(newProperty);
    }

    public String[] getPepositoryPropertyNames() {
        return new String[]{"version", "timezone", "encoding"};
    }

    public abstract boolean markStaleTasks(TaskRepository var1, Set<AbstractTask> var2, IProgressMonitor var3) throws CoreException;

    public void addTemplate(RepositoryTemplate template) {
        this.templates.add(template);
    }

    public Set<RepositoryTemplate> getTemplates() {
        return this.templates;
    }

    public void removeTemplate(RepositoryTemplate template) {
        this.templates.remove(template);
    }

    public RepositoryTemplate getTemplate(String label) {
        for (RepositoryTemplate template : this.getTemplates()) {
            if (!template.label.equals(label)) continue;
            return template;
        }
        return null;
    }

    public String getTaskIdPrefix() {
        return "task";
    }

    public abstract void updateAttributes(TaskRepository var1, IProgressMonitor var2) throws CoreException;

    public boolean isRepositoryConfigurationStale(TaskRepository repository) throws CoreException {
        boolean isStale = true;
        Date configDate = repository.getConfigurationDate();
        if (configDate != null) {
            isStale = new Date().getTime() - configDate.getTime() > 86400000L;
        }
        return isStale;
    }

    public void setUserManaged(boolean userManaged) {
        this.userManaged = userManaged;
    }

    public boolean isUserManaged() {
        return this.userManaged;
    }

    public boolean hasCredentialsManagement() {
        return false;
    }

    public String getSynchronizationTimestamp(TaskRepository repository, Set<AbstractTask> changedTasks) {
        Date mostRecent = new Date(0L);
        String mostRecentTimeStamp = repository.getSynchronizationTimeStamp();
        for (AbstractTask task : changedTasks) {
            Date taskModifiedDate;
            RepositoryTaskData taskData = this.getTaskData(task);
            if (taskData == null || this.getTaskDataHandler() == null || taskData.getLastModified() == null || (taskModifiedDate = taskData.getAttributeFactory().getDateForAttributeType("task.common.date.modified", taskData.getLastModified())) == null || !taskModifiedDate.after(mostRecent)) continue;
            mostRecent = taskModifiedDate;
            mostRecentTimeStamp = taskData.getLastModified();
        }
        return mostRecentTimeStamp;
    }

    private RepositoryTaskData getTaskData(AbstractTask task) {
        if (this.taskDataManager != null) {
            return this.taskDataManager.getNewTaskData(task.getRepositoryUrl(), task.getTaskId());
        }
        return null;
    }

    private TaskDataManager getTaskDataManager() {
        return this.taskDataManager;
    }
}

