/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskTimingListener;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskActivityManager {
    private static final int NUM_WEEKS_PREVIOUS_START = -1;
    private static final int NUM_WEEKS_PREVIOUS_END = -1;
    private static final int NUM_WEEKS_NEXT = 1;
    private static final int NUM_WEEKS_FUTURE_START = 2;
    private static final int NUM_WEEKS_PAST_END = -2;
    private static final String DESCRIPTION_THIS_WEEK = "This Week";
    private static final String DESCRIPTION_PREVIOUS_WEEK = "Previous Week";
    private static final String DESCRIPTION_NEXT_WEEK = "Next Week";
    private static final String DESCRIPTION_FUTURE = "Future";
    private static final String DESCRIPTION_PAST = "Past";
    private SortedMap<Calendar, Set<AbstractTask>> scheduledTasks = Collections.synchronizedSortedMap(new TreeMap());
    private SortedMap<Calendar, Set<AbstractTask>> dueTasks = Collections.synchronizedSortedMap(new TreeMap());
    private SortedMap<Calendar, Set<AbstractTask>> activeTasks = Collections.synchronizedSortedMap(new TreeMap());
    private Map<AbstractTask, SortedMap<Calendar, Long>> taskElapsedTimeMap = new ConcurrentHashMap<AbstractTask, SortedMap<Calendar, Long>>();
    private List<ScheduledTaskContainer> scheduleWeekDays = new ArrayList<ScheduledTaskContainer>();
    private ArrayList<ScheduledTaskContainer> scheduleContainers = new ArrayList();
    private List<ITaskTimingListener> timingListeners = new ArrayList<ITaskTimingListener>();
    private ScheduledTaskContainer scheduledThisWeek;
    private ScheduledTaskContainer scheduledNextWeek;
    private ScheduledTaskContainer scheduledFuture;
    private ScheduledTaskContainer scheduledPast;
    private ScheduledTaskContainer scheduledPrevious;
    private int timeTicks;
    private int startHour = 9;
    private int endHour = 17;
    private boolean taskActivityHistoryInitialized = false;
    private TaskList taskList;
    private TaskRepositoryManager repositoryManager;
    private int startDay = 2;
    private int endDay = 1;
    private Date startTime = new Date();
    private static TaskActivityManager INSTANCE;
    private final IInteractionContextListener CONTEXT_LISTENER = new IInteractionContextListener(){

        public void contextActivated(IInteractionContext context) {
        }

        public void contextDeactivated(IInteractionContext context) {
        }

        public void contextCleared(IInteractionContext context) {
        }

        public void interestChanged(List<IInteractionElement> elements) {
            List events = ContextCorePlugin.getContextManager().getActivityMetaContext().getInteractionHistory();
            InteractionEvent event = (InteractionEvent)events.get(events.size() - 1);
            TaskActivityManager.this.parseInteractionEvent(event);
        }

        public void elementDeleted(IInteractionElement element) {
        }

        public void landmarkAdded(IInteractionElement element) {
        }

        public void landmarkRemoved(IInteractionElement element) {
        }

        public void relationsChanged(IInteractionElement element) {
        }
    };
    private boolean isInitialized = false;

    private TaskActivityManager() {
    }

    public static synchronized TaskActivityManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TaskActivityManager();
        }
        return INSTANCE;
    }

    public void init(TaskRepositoryManager repositoryManager, TaskList taskList) {
        this.taskList = taskList;
        this.repositoryManager = repositoryManager;
        if (!this.isInitialized) {
            ContextCorePlugin.getContextManager().addActivityMetaContextListener(this.CONTEXT_LISTENER);
        }
        this.isInitialized = true;
    }

    public void dispose() {
        ContextCorePlugin.getContextManager().removeActivityMetaContextListener(this.CONTEXT_LISTENER);
    }

    public int getStartDay() {
        return this.startDay;
    }

    public void setStartDay(int startDay) {
        this.startDay = startDay;
    }

    public int getEndDay() {
        return this.endDay;
    }

    public void setEndDay(int endDay) {
        this.endDay = endDay;
    }

    public int getStartHour() {
        return this.startHour;
    }

    public void setStartHour(int startHour) {
        this.startHour = startHour;
    }

    public void setEndHour(int endHour) {
        this.endHour = endHour;
    }

    public int getEndHour() {
        return this.endHour;
    }

    private void clear() {
        this.dueTasks.clear();
        this.scheduledTasks.clear();
        this.activeTasks.clear();
        this.taskElapsedTimeMap.clear();
    }

    public void reloadTimingData(Date date) {
        this.startTime = date;
        this.taskActivityHistoryInitialized = false;
        this.clear();
        List events = ContextCorePlugin.getContextManager().getActivityMetaContext().getInteractionHistory();
        for (InteractionEvent event : events) {
            this.parseInteractionEvent(event);
        }
        this.reloadScheduledData();
        this.setupCalendarRanges();
        this.taskActivityHistoryInitialized = true;
    }

    public void parseInteractionEvent(InteractionEvent event) {
        try {
            if (event.getKind().equals((Object)InteractionEvent.Kind.ATTENTION) && (event.getDelta().equals("added") || event.getDelta().equals("add"))) {
                AbstractTask activatedTask = this.taskList.getTask(event.getStructureHandle());
                if (activatedTask != null) {
                    this.addElapsedTimeForEvent(activatedTask, event);
                    ++this.timeTicks;
                    if (this.taskActivityHistoryInitialized && this.timeTicks > 3) {
                        ContextCorePlugin.getContextManager().saveActivityContext();
                        this.timeTicks = 0;
                    }
                }
                return;
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error parsing interaction event", t));
        }
    }

    private void addElapsedTimeForEvent(AbstractTask activatedTask, InteractionEvent event) {
        long attentionSpan;
        SortedMap<Calendar, Long> activityMap = this.taskElapsedTimeMap.get(activatedTask);
        if (activityMap == null) {
            activityMap = Collections.synchronizedSortedMap(new TreeMap());
            this.taskElapsedTimeMap.put(activatedTask, activityMap);
        }
        if ((attentionSpan = event.getEndDate().getTime() - event.getDate().getTime()) <= 0L) {
            return;
        }
        Calendar hourOfDay = Calendar.getInstance();
        hourOfDay.setTime(event.getDate());
        this.snapToStartOfHour(hourOfDay);
        Long daysActivity = (Long)activityMap.get(hourOfDay);
        if (daysActivity == null) {
            daysActivity = new Long(0L);
        }
        daysActivity = daysActivity + attentionSpan;
        activityMap.put(hourOfDay, daysActivity);
        HashSet<AbstractTask> active = (HashSet<AbstractTask>)this.activeTasks.get(hourOfDay);
        if (active == null) {
            active = new HashSet<AbstractTask>();
            this.activeTasks.put(hourOfDay, active);
        }
        active.add(activatedTask);
        long totalElapsed = this.getElapsedTime(activityMap);
        for (ITaskTimingListener listener : new ArrayList<ITaskTimingListener>(this.timingListeners)) {
            try {
                listener.elapsedTimeUpdated(activatedTask, totalElapsed);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task activity listener failed: \"" + listener + "\"", t));
            }
        }
    }

    private void addScheduledTask(AbstractTask task) {
        Calendar time = Calendar.getInstance();
        time.setTime(task.getScheduledForDate());
        this.snapToStartOfHour(time);
        CopyOnWriteArraySet<AbstractTask> tasks = (CopyOnWriteArraySet<AbstractTask>)this.scheduledTasks.get(time);
        if (tasks == null) {
            tasks = new CopyOnWriteArraySet<AbstractTask>();
            this.scheduledTasks.put(time, tasks);
        }
        tasks.add(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeScheduledTask(AbstractTask task) {
        SortedMap<Calendar, Set<AbstractTask>> sortedMap = this.scheduledTasks;
        synchronized (sortedMap) {
            for (Set<AbstractTask> setOfTasks : this.scheduledTasks.values()) {
                setOfTasks.remove(task);
            }
        }
    }

    private void addDueTask(AbstractTask task) {
        Calendar time = Calendar.getInstance();
        time.setTime(task.getDueDate());
        this.snapToStartOfHour(time);
        CopyOnWriteArraySet<AbstractTask> tasks = (CopyOnWriteArraySet<AbstractTask>)this.dueTasks.get(time);
        if (tasks == null) {
            tasks = new CopyOnWriteArraySet<AbstractTask>();
            this.dueTasks.put(time, tasks);
        }
        tasks.add(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDueTask(AbstractTask task) {
        SortedMap<Calendar, Set<AbstractTask>> sortedMap = this.dueTasks;
        synchronized (sortedMap) {
            for (Set<AbstractTask> setOfTasks : this.dueTasks.values()) {
                setOfTasks.remove(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AbstractTask> getActiveTasks(Calendar start, Calendar end) {
        HashSet<AbstractTask> resultingTasks = new HashSet<AbstractTask>();
        SortedMap<Calendar, Set<AbstractTask>> result = this.activeTasks.subMap(start, end);
        SortedMap<Calendar, Set<AbstractTask>> sortedMap = this.activeTasks;
        synchronized (sortedMap) {
            for (Set<AbstractTask> set : result.values()) {
                resultingTasks.addAll(set);
            }
        }
        return resultingTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AbstractTask> getScheduledTasks(Calendar start, Calendar end) {
        HashSet<AbstractTask> resultingTasks = new HashSet<AbstractTask>();
        SortedMap<Calendar, Set<AbstractTask>> result = this.scheduledTasks.subMap(start, end);
        SortedMap<Calendar, Set<AbstractTask>> sortedMap = this.scheduledTasks;
        synchronized (sortedMap) {
            for (Set<AbstractTask> set : result.values()) {
                resultingTasks.addAll(set);
            }
        }
        return resultingTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AbstractTask> getDueTasks(Calendar start, Calendar end) {
        HashSet<AbstractTask> resultingTasks = new HashSet<AbstractTask>();
        SortedMap<Calendar, Set<AbstractTask>> result = this.dueTasks.subMap(start, end);
        SortedMap<Calendar, Set<AbstractTask>> sortedMap = this.dueTasks;
        synchronized (sortedMap) {
            for (Set<AbstractTask> set : result.values()) {
                resultingTasks.addAll(set);
            }
        }
        return resultingTasks;
    }

    public long getElapsedTime(AbstractTask task) {
        SortedMap<Calendar, Long> activityMap = this.taskElapsedTimeMap.get(task);
        return this.getElapsedTime(activityMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getElapsedTime(SortedMap<Calendar, Long> activityMap) {
        long result = 0L;
        if (activityMap != null) {
            SortedMap<Calendar, Long> sortedMap = activityMap;
            synchronized (sortedMap) {
                for (Long time : activityMap.values()) {
                    if (time == null) continue;
                    result += time.longValue();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getElapsedTime(AbstractTask task, Calendar start, Calendar end) {
        long result = 0L;
        Calendar startRange = Calendar.getInstance();
        startRange.setTimeInMillis(start.getTimeInMillis());
        this.snapToStartOfHour(startRange);
        Calendar endRange = Calendar.getInstance();
        endRange.setTimeInMillis(end.getTimeInMillis());
        this.snapToEndOfHour(endRange);
        SortedMap<Calendar, Long> activityMap = this.taskElapsedTimeMap.get(task);
        if (activityMap != null) {
            SortedMap<Calendar, Long> sortedMap = activityMap;
            synchronized (sortedMap) {
                activityMap = activityMap.subMap(startRange, endRange);
                for (Long time : activityMap.values()) {
                    if (time == null) continue;
                    result += time.longValue();
                }
            }
        }
        return result;
    }

    private void snapToStartOfHour(Calendar cal) {
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.getTime();
    }

    private void snapToEndOfHour(Calendar cal) {
        cal.set(12, cal.getMaximum(12));
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        cal.getTime();
    }

    public void snapToNextDay(Calendar cal) {
        cal.add(5, 1);
        TaskActivityUtil.snapStartOfDay(cal);
    }

    public AbstractTask getActiveTask() {
        return this.taskList.getActiveTask();
    }

    private void reloadScheduledData() {
        for (AbstractTask task : this.taskList.getAllTasks()) {
            if (task.getScheduledForDate() != null) {
                this.addScheduledTask(task);
            }
            if (task.getDueDate() == null) continue;
            this.addDueTask(task);
        }
    }

    public void setScheduledFor(AbstractTask task, Date reminderDate) {
        this.setScheduledFor(task, reminderDate, false);
    }

    public void setScheduledFor(AbstractTask task, Date reminderDate, boolean floating) {
        if (task == null) {
            return;
        }
        if (reminderDate != null && !reminderDate.equals(task.getScheduledForDate())) {
            task.setReminded(false);
        }
        task.setScheduledForDate(reminderDate);
        task.internalSetFloatingScheduledDate(floating);
        if (reminderDate == null) {
            this.removeScheduledTask(task);
        } else {
            this.removeScheduledTask(task);
            this.addScheduledTask(task);
        }
        this.taskList.notifyTaskChanged(task, false);
    }

    public void setDueDate(AbstractTask task, Date dueDate) {
        task.setDueDate(dueDate);
        if (dueDate == null) {
            this.removeDueTask(task);
        } else {
            this.removeDueTask(task);
            this.addDueTask(task);
        }
        this.taskList.notifyTaskChanged(task, false);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isCompletedToday(AbstractTask task) {
        if (task != null) {
            boolean isOwnedByUser = this.repositoryManager.isOwnedByUser(task);
            if (!isOwnedByUser) {
                return false;
            }
            Date completionDate = task.getCompletionDate();
            if (completionDate != null) {
                Calendar completedTime = TaskActivityUtil.getCalendar();
                completedTime.setTime(completionDate);
                return TaskActivityUtil.isToday(completedTime);
            }
        }
        return false;
    }

    public boolean isPastReminder(AbstractTask task) {
        if (task == null || task.isCompleted() || task.getScheduledForDate() == null) {
            return false;
        }
        return this.isPastReminder(task.getScheduledForDate(), task.isCompleted());
    }

    public boolean isPastReminder(Date date, boolean isComplete) {
        if (date == null || isComplete) {
            return false;
        }
        Date now = new Date();
        return date.compareTo(now) < 0;
    }

    public boolean isOverdue(AbstractTask task) {
        return !task.isCompleted() && task.getDueDate() != null && new Date().after(task.getDueDate()) && this.repositoryManager.isOwnedByUser(task);
    }

    public boolean isOwnedByUser(AbstractTask task) {
        return this.repositoryManager.isOwnedByUser(task);
    }

    public boolean isActiveThisWeek(AbstractTask task) {
        Calendar calStart = Calendar.getInstance();
        TaskActivityUtil.snapStartOfWorkWeek(calStart);
        Calendar calEnd = Calendar.getInstance();
        TaskActivityUtil.snapEndOfWeek(calEnd);
        return this.getElapsedTime(task, calStart, calEnd) > 0L;
    }

    public boolean isScheduledForToday(AbstractTask task) {
        Date reminder;
        if (task != null && (reminder = task.getScheduledForDate()) != null && !task.internalIsFloatingScheduledDate()) {
            Calendar time = TaskActivityUtil.getCalendar();
            time.setTime(reminder);
            return TaskActivityUtil.isToday(time);
        }
        return false;
    }

    public boolean isScheduledForToday(Date date, boolean floating) {
        if (date != null && !floating) {
            Calendar time = TaskActivityUtil.getCalendar();
            time.setTime(date);
            return TaskActivityUtil.isToday(time);
        }
        return false;
    }

    public boolean isScheduledAfterThisWeek(AbstractTask task) {
        if (task.getScheduledForDate() != null) {
            return this.isScheduledAfterThisWeek(task.getScheduledForDate());
        }
        return false;
    }

    public boolean isScheduledAfterThisWeek(Date date) {
        Calendar cal = TaskActivityUtil.getCalendar();
        if (date != null) {
            cal.setTime(date);
            return TaskActivityUtil.isAfterCurrentWeek(cal);
        }
        return false;
    }

    public boolean isScheduledForFuture(AbstractTask task) {
        if (task != null) {
            Date reminder = task.getScheduledForDate();
            return this.isScheduledForFuture(reminder);
        }
        return false;
    }

    public boolean isScheduledForFuture(Date reminder) {
        if (reminder != null) {
            Calendar cal = TaskActivityUtil.getCalendar();
            cal.setTime(reminder);
            return TaskActivityUtil.isFuture(cal);
        }
        return false;
    }

    public boolean isScheduledForThisWeek(AbstractTask task) {
        boolean result = false;
        if (task != null) {
            Date reminder = task.getScheduledForDate();
            result = this.isScheduledForThisWeek(reminder);
        }
        return result;
    }

    public boolean isScheduledForThisWeek(Date reminder) {
        if (reminder != null) {
            Calendar time = TaskActivityUtil.getCalendar();
            time.setTime(reminder);
            return TaskActivityUtil.isThisWeek(time);
        }
        return false;
    }

    public boolean isScheduledForNextWeek(AbstractTask task) {
        Date reminder;
        if (task != null && (reminder = task.getScheduledForDate()) != null) {
            Calendar time = TaskActivityUtil.getCalendar();
            time.setTime(reminder);
            return TaskActivityUtil.isNextWeek(time);
        }
        return false;
    }

    private void setupCalendarRanges() {
        this.scheduleContainers.clear();
        this.scheduleWeekDays.clear();
        int startDay = TaskActivityManager.getInstance().getStartDay();
        Calendar pastStart = TaskActivityUtil.getCalendar();
        pastStart.setTimeInMillis(0L);
        GregorianCalendar pastEnd = new GregorianCalendar();
        pastEnd.setFirstDayOfWeek(startDay);
        pastEnd.setTime(this.startTime);
        pastEnd.add(3, -2);
        TaskActivityUtil.snapEndOfWeek(pastEnd);
        this.scheduledPast = new ScheduledTaskContainer(this, pastStart.getTime(), pastEnd.getTime(), DESCRIPTION_PAST);
        this.scheduleWeekDays.clear();
        int x = startDay;
        while (x < startDay + 7) {
            GregorianCalendar dayStart = new GregorianCalendar();
            GregorianCalendar dayEnd = new GregorianCalendar();
            dayStart.setFirstDayOfWeek(startDay);
            dayEnd.setFirstDayOfWeek(startDay);
            if (x > 7) {
                dayStart.set(7, x % 7);
                dayEnd.set(7, x % 7);
            } else {
                dayStart.set(7, x);
                dayEnd.set(7, x);
            }
            dayStart.set(11, 0);
            dayStart.set(12, 0);
            dayStart.set(13, 0);
            dayStart.set(14, 0);
            dayStart.getTime();
            dayEnd.set(11, dayEnd.getMaximum(11));
            dayEnd.set(12, dayEnd.getMaximum(12));
            dayEnd.set(13, dayEnd.getMaximum(13));
            dayEnd.set(14, dayEnd.getMaximum(14));
            dayEnd.getTime();
            String summary = "<unknown>";
            switch (dayStart.get(7)) {
                case 2: {
                    summary = "Monday";
                    break;
                }
                case 3: {
                    summary = "Tuesday";
                    break;
                }
                case 4: {
                    summary = "Wednesday";
                    break;
                }
                case 5: {
                    summary = "Thursday";
                    break;
                }
                case 6: {
                    summary = "Friday";
                    break;
                }
                case 7: {
                    summary = "Saturday";
                    break;
                }
                case 1: {
                    summary = "Sunday";
                }
            }
            ScheduledTaskContainer day = new ScheduledTaskContainer(this, dayStart, dayEnd, summary);
            this.scheduleWeekDays.add(day);
            this.scheduleContainers.add(day);
            ++x;
        }
        Calendar currentBegin = TaskActivityUtil.getCalendar();
        currentBegin.setTime(this.startTime);
        TaskActivityUtil.snapStartOfWorkWeek(currentBegin);
        Calendar currentEnd = TaskActivityUtil.getCalendar();
        currentEnd.setTime(this.startTime);
        TaskActivityUtil.snapEndOfWeek(currentEnd);
        this.scheduledThisWeek = new ScheduledTaskContainer(this, currentBegin, currentEnd, DESCRIPTION_THIS_WEEK);
        this.scheduledThisWeek.setCaptureFloating(true);
        GregorianCalendar nextStart = new GregorianCalendar();
        nextStart.setFirstDayOfWeek(startDay);
        nextStart.setTime(this.startTime);
        nextStart.add(3, 1);
        TaskActivityUtil.snapStartOfWorkWeek(nextStart);
        GregorianCalendar nextEnd = new GregorianCalendar();
        nextEnd.setFirstDayOfWeek(startDay);
        nextEnd.setTime(this.startTime);
        nextEnd.add(3, 1);
        TaskActivityUtil.snapEndOfWeek(nextEnd);
        this.scheduledNextWeek = new ScheduledTaskContainer(this, nextStart.getTime(), nextEnd.getTime(), DESCRIPTION_NEXT_WEEK);
        this.scheduledNextWeek.setCaptureFloating(true);
        this.scheduleContainers.add(this.scheduledNextWeek);
        GregorianCalendar futureStart = new GregorianCalendar();
        futureStart.setFirstDayOfWeek(startDay);
        futureStart.setTime(this.startTime);
        futureStart.add(3, 2);
        TaskActivityUtil.snapStartOfWorkWeek(futureStart);
        GregorianCalendar futureEnd = new GregorianCalendar();
        futureEnd.setFirstDayOfWeek(startDay);
        futureEnd.setTime(this.startTime);
        futureEnd.add(1, 1);
        TaskActivityUtil.snapEndOfWeek(futureEnd);
        this.scheduledFuture = new ScheduledTaskContainer(this, futureStart.getTime(), futureEnd.getTime(), DESCRIPTION_FUTURE);
        this.scheduledFuture.setCaptureFloating(true);
        this.scheduleContainers.add(this.scheduledFuture);
        GregorianCalendar previousStart = new GregorianCalendar();
        previousStart.setFirstDayOfWeek(startDay);
        previousStart.setTime(this.startTime);
        previousStart.add(3, -1);
        TaskActivityUtil.snapStartOfWorkWeek(previousStart);
        GregorianCalendar previousEnd = new GregorianCalendar();
        previousEnd.setFirstDayOfWeek(startDay);
        previousEnd.setTime(this.startTime);
        previousEnd.add(3, -1);
        TaskActivityUtil.snapEndOfWeek(previousEnd);
        this.scheduledPrevious = new ScheduledTaskContainer(this, previousStart.getTime(), previousEnd.getTime(), DESCRIPTION_PREVIOUS_WEEK);
    }

    public List<ScheduledTaskContainer> getDateRanges() {
        return this.scheduleContainers;
    }

    public List<ScheduledTaskContainer> getActivityWeekDays() {
        return this.scheduleWeekDays;
    }

    public boolean isWeekDay(ScheduledTaskContainer dateRangeTaskContainer) {
        return this.scheduleWeekDays.contains(dateRangeTaskContainer);
    }

    public ScheduledTaskContainer getActivityThisWeek() {
        return this.scheduledThisWeek;
    }

    public ScheduledTaskContainer getActivityPast() {
        return this.scheduledPast;
    }

    public ScheduledTaskContainer getActivityFuture() {
        return this.scheduledFuture;
    }

    public ScheduledTaskContainer getActivityNextWeek() {
        return this.scheduledNextWeek;
    }

    public ScheduledTaskContainer getActivityPrevious() {
        return this.scheduledPrevious;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void scheduleNewTask(AbstractTask newTask) {
        newTask.setCreationDate(new Date());
        Calendar newTaskSchedule = Calendar.getInstance();
        if (newTaskSchedule.get(11) >= this.getEndHour()) {
            TaskActivityUtil.snapForwardNumDays(newTaskSchedule, 1);
        } else {
            TaskActivityUtil.snapEndOfWorkDay(newTaskSchedule);
        }
        this.setScheduledFor(newTask, newTaskSchedule.getTime());
    }

    public boolean isDueThisWeek(AbstractTask task) {
        Date due = task.getDueDate();
        if (due != null && this.repositoryManager.isOwnedByUser(task)) {
            Calendar cal = TaskActivityUtil.getCalendar();
            cal.setTime(due);
            return TaskActivityUtil.isThisWeek(cal);
        }
        return false;
    }

    public void addTimingListener(ITaskTimingListener listener) {
        this.timingListeners.add(listener);
    }

    public void removeTimingListener(ITaskTimingListener listener) {
        this.timingListeners.remove(listener);
    }

    public boolean isFloatingThisWeek(AbstractTask singleTaskSelection) {
        return singleTaskSelection != null && singleTaskSelection.getScheduledForDate() != null && singleTaskSelection.internalIsFloatingScheduledDate() && this.isScheduledForThisWeek(singleTaskSelection.getScheduledForDate());
    }
}

