/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledTaskDelegate
extends AbstractTask {
    private AbstractTask task = null;
    private ScheduledTaskContainer parent;
    private long startMili = 0L;
    private long endMili = 0L;
    private long activity = 0L;

    public ScheduledTaskDelegate(ScheduledTaskContainer parent, AbstractTask task, Calendar start, Calendar end) {
        this(parent, task, start, end, 0L);
    }

    public ScheduledTaskDelegate(ScheduledTaskContainer parent, AbstractTask task, Calendar start, Calendar end, long activity) {
        super(task.getRepositoryUrl(), task.getTaskId(), task.getSummary());
        this.task = task;
        if (start != null) {
            this.startMili = start.getTimeInMillis();
        }
        if (end != null) {
            this.endMili = end.getTimeInMillis();
        }
        this.parent = parent;
        this.activity = activity;
    }

    public long getEnd() {
        return this.endMili;
    }

    public long getStart() {
        return this.startMili;
    }

    public long getActivity() {
        return this.activity;
    }

    public AbstractTask getCorrespondingTask() {
        return this.task;
    }

    public ScheduledTaskContainer getDateRangeContainer() {
        return this.parent;
    }

    @Override
    public Set<AbstractTaskContainer> getParentContainers() {
        return this.task.getParentContainers();
    }

    @Override
    public Set<AbstractTask> getChildren() {
        return this.task.getChildren();
    }

    @Override
    public Date getCompletionDate() {
        return this.task.getCompletionDate();
    }

    @Override
    public Date getCreationDate() {
        return this.task.getCreationDate();
    }

    @Override
    public String getSummary() {
        return this.task.getSummary();
    }

    @Override
    public int getEstimateTimeHours() {
        return this.task.getEstimateTimeHours();
    }

    @Override
    public String getTaskKind() {
        return this.task.getTaskKind();
    }

    @Override
    public String getNotes() {
        return this.task.getNotes();
    }

    @Override
    public String getPriority() {
        return this.task.getPriority();
    }

    @Override
    public Date getScheduledForDate() {
        return this.task.getScheduledForDate();
    }

    @Override
    public String getUrl() {
        return this.task.getUrl();
    }

    @Override
    public boolean isReminded() {
        return this.task.isReminded();
    }

    @Override
    public boolean hasValidUrl() {
        return this.task.hasValidUrl();
    }

    @Override
    public boolean isActive() {
        return this.task.isActive();
    }

    @Override
    public boolean isCompleted() {
        return this.task.isCompleted();
    }

    @Override
    public boolean isPastReminder() {
        return this.task.isPastReminder();
    }

    @Override
    public void setActive(boolean active) {
        this.task.setActive(active);
    }

    @Override
    public void addParentContainer(AbstractTaskContainer container) {
        this.task.addParentContainer(container);
    }

    @Override
    public void removeParentContainer(AbstractTaskContainer container) {
        this.task.removeParentContainer(container);
    }

    @Override
    public void setCompleted(boolean completed) {
        this.task.setCompleted(completed);
    }

    @Override
    public void setCompletionDate(Date date) {
        this.task.setCompletionDate(date);
    }

    @Override
    public void setCreationDate(Date date) {
        this.task.setCreationDate(date);
    }

    @Override
    public void setEstimatedTimeHours(int estimated) {
        this.task.setEstimatedTimeHours(estimated);
    }

    @Override
    public void setTaskKind(String kind) {
        this.task.setTaskKind(kind);
    }

    @Override
    public void setNotes(String notes) {
        this.task.setNotes(notes);
    }

    @Override
    public void setPriority(String priority) {
        this.task.setPriority(priority);
    }

    @Override
    public void setReminded(boolean reminded) {
        this.task.setReminded(reminded);
    }

    @Override
    public void setScheduledForDate(Date date) {
        this.task.setScheduledForDate(date);
    }

    @Override
    public void setUrl(String url) {
        this.task.setUrl(url);
    }

    @Override
    public int compareTo(AbstractTaskContainer taskListElement) {
        return this.task.toString().compareTo(((AbstractTask)taskListElement).toString());
    }

    @Override
    public void setSummary(String description) {
        this.task.setSummary(description);
    }

    @Override
    public Date getDueDate() {
        return this.task.getDueDate();
    }

    @Override
    public void setDueDate(Date date) {
        this.task.setDueDate(date);
    }

    @Override
    public boolean isLocal() {
        return this.task.isLocal();
    }

    @Override
    public String getConnectorKind() {
        return this.task.getConnectorKind();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.endMili ^ this.endMili >>> 32);
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (int)(this.startMili ^ this.startMili >>> 32);
        result = 31 * result + (this.task == null ? 0 : this.task.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduledTaskDelegate other = (ScheduledTaskDelegate)obj;
        if (this.endMili != other.endMili) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (this.startMili != other.startMili) {
            return false;
        }
        return !(this.task == null ? other.task != null : !this.task.equals(other.task));
    }

    @Override
    public Set<AbstractTask> getChildrenInternal() {
        return this.task.getChildrenInternal();
    }
}

