/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.monitor.core.util.XmlStringConverter;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaxRepositoriesWriter {
    private OutputStream outputStream;

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void writeRepositoriesToStream(Collection<TaskRepository> repositories) throws IOException {
        if (this.outputStream == null) {
            IOException ioe = new IOException("OutputStream not set");
            throw ioe;
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new SAXSource(new RepositoriesWriter(), new TaskRepositoriesInputSource(repositories)), new StreamResult(this.outputStream));
        }
        catch (TransformerException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not write repositories", (Throwable)e));
            throw new IOException(e.getMessage());
        }
    }

    private static class RepositoriesWriter
    implements XMLReader {
        private ContentHandler handler;
        private ErrorHandler errorHandler;

        private RepositoriesWriter() {
        }

        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return false;
        }

        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return null;
        }

        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        public void setEntityResolver(EntityResolver resolver) {
        }

        public EntityResolver getEntityResolver() {
            return null;
        }

        public void setDTDHandler(DTDHandler handler) {
        }

        public DTDHandler getDTDHandler() {
            return null;
        }

        public void setContentHandler(ContentHandler handler) {
            this.handler = handler;
        }

        public ContentHandler getContentHandler() {
            return this.handler;
        }

        public void setErrorHandler(ErrorHandler handler) {
            this.errorHandler = handler;
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        public void parse(InputSource input) throws IOException, SAXException {
            if (!(input instanceof TaskRepositoriesInputSource)) {
                throw new SAXException("Can only parse writable input sources");
            }
            Collection<TaskRepository> repositories = ((TaskRepositoriesInputSource)input).getRepositories();
            this.handler.startDocument();
            AttributesImpl rootAttributes = new AttributesImpl();
            rootAttributes.addAttribute("", "OutputVersion", "OutputVersion", "", "1");
            this.handler.startElement("", "TaskRepositories", "TaskRepositories", rootAttributes);
            for (TaskRepository repository : new ArrayList<TaskRepository>(repositories)) {
                AttributesImpl ieAttributes = new AttributesImpl();
                for (String key : repository.getProperties().keySet()) {
                    ieAttributes.addAttribute("", key, key, "", XmlStringConverter.convertToXmlString((String)repository.getProperties().get(key)));
                }
                this.handler.startElement("", "TaskRepository", "TaskRepository", ieAttributes);
                this.handler.endElement("", "TaskRepository", "TaskRepository");
            }
            this.handler.endElement("", "TaskRepositories", "TaskRepositories");
            this.handler.endDocument();
        }

        public void parse(String systemId) throws IOException, SAXException {
            throw new SAXException("Can only parse writable input sources");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskRepositoriesInputSource
    extends InputSource {
        private Collection<TaskRepository> repositories;

        public TaskRepositoriesInputSource(Collection<TaskRepository> repositories) {
            this.repositories = repositories;
        }

        public Collection<TaskRepository> getRepositories() {
            return this.repositories;
        }
    }
}

