/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylyn.internal.monitor.core.util.XmlStringConverter;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaxRepositoriesContentHandler
extends DefaultHandler {
    static final String ATTRIBUTE_INTERACTION_EVENT = "InteractionEvent";
    private Set<TaskRepository> taskRepositories = new HashSet<TaskRepository>();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (localName.equals("TaskRepository") && attributes != null) {
                String kind = XmlStringConverter.convertXmlToString((String)attributes.getValue("kind"));
                String url = XmlStringConverter.convertXmlToString((String)attributes.getValue("url"));
                if (kind != null && kind.length() > 0 && url != null && url.length() > 0) {
                    TaskRepository repository = new TaskRepository(kind, url);
                    int index = 0;
                    while (index < attributes.getLength()) {
                        String key = XmlStringConverter.convertXmlToString((String)attributes.getLocalName(index));
                        String value = XmlStringConverter.convertXmlToString((String)attributes.getValue(index));
                        repository.setProperty(key, value);
                        ++index;
                    }
                    this.taskRepositories.add(repository);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Set<TaskRepository> getRepositories() {
        return this.taskRepositories;
    }
}

