/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.InputStream;
import java.util.List;
import org.eclipse.compare.internal.patch.FileDiffResult;
import org.eclipse.compare.internal.patch.Hunk;
import org.eclipse.compare.internal.patch.Patcher;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class HunkResult
implements IHunk {
    private static final boolean DEBUG = false;
    private Hunk fHunk;
    private boolean fMatches;
    private int fShift;
    private final FileDiffResult fDiffResult;

    public HunkResult(FileDiffResult diffResult, Hunk hunk) {
        this.fDiffResult = diffResult;
        this.fHunk = hunk;
    }

    public boolean patch(List lines) {
        this.fMatches = false;
        PatchConfiguration configuration = this.getConfiguration();
        if (this.isEnabled(configuration)) {
            if (this.fHunk.tryPatch(configuration, lines, this.fShift)) {
                this.fShift += this.fHunk.doPatch(configuration, lines, this.fShift);
                this.fMatches = true;
            } else {
                boolean found = false;
                int i = 1;
                while (i <= this.fDiffResult.getFuzz()) {
                    if (this.fHunk.tryPatch(configuration, lines, this.fShift - i)) {
                        if (this.isAdjustShift()) {
                            this.fShift -= i;
                        }
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    i = 1;
                    while (i <= this.fDiffResult.getFuzz()) {
                        if (this.fHunk.tryPatch(configuration, lines, this.fShift + i)) {
                            if (this.isAdjustShift()) {
                                this.fShift += i;
                            }
                            found = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (found) {
                    this.fShift += this.fHunk.doPatch(configuration, lines, this.fShift);
                    this.fMatches = true;
                }
            }
        }
        return this.fMatches;
    }

    private boolean isAdjustShift() {
        return true;
    }

    private PatchConfiguration getConfiguration() {
        return this.getDiffResult().getConfiguration();
    }

    public int calculateFuzz(List lines, IProgressMonitor monitor) {
        this.fMatches = false;
        int fuzz = 0;
        PatchConfiguration configuration = this.getConfiguration();
        if (this.fHunk.tryPatch(configuration, lines, this.fShift)) {
            this.fShift += this.fHunk.doPatch(configuration, lines, this.fShift);
            this.fMatches = true;
        } else {
            int hugeFuzz = lines.size();
            fuzz = -1;
            int i = 1;
            while (i <= hugeFuzz) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (this.fHunk.tryPatch(configuration, lines, this.fShift - i)) {
                    fuzz = i;
                    if (this.isAdjustShift()) {
                        this.fShift -= i;
                    }
                    this.fMatches = true;
                    break;
                }
                ++i;
            }
            if (!this.fMatches) {
                i = 1;
                while (i <= hugeFuzz) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (this.fHunk.tryPatch(configuration, lines, this.fShift + i)) {
                        fuzz = i;
                        if (this.isAdjustShift()) {
                            this.fShift += i;
                        }
                        this.fMatches = true;
                        break;
                    }
                    ++i;
                }
            }
            if (this.fMatches) {
                this.fShift += this.fHunk.doPatch(configuration, lines, this.fShift);
            }
        }
        return fuzz;
    }

    public int getShift() {
        return this.fShift;
    }

    public void setShift(int shift) {
        this.fShift = shift;
    }

    public Hunk getHunk() {
        return this.fHunk;
    }

    public FileDiffResult getDiffResult() {
        return this.fDiffResult;
    }

    public boolean isOK() {
        return this.fMatches;
    }

    public String getContents(boolean afterState, boolean fullContext) {
        if (fullContext) {
            boolean problemFound = false;
            List lines = this.getDiffResult().getBeforeLines();
            if (afterState) {
                if (this.isOK()) {
                    int oldShift = this.fShift;
                    try {
                        this.fShift = 0;
                        problemFound = !this.patch(lines);
                    }
                    finally {
                        this.fShift = oldShift;
                    }
                } else {
                    problemFound = true;
                }
            }
            if (!problemFound) {
                return Patcher.createString(this.fDiffResult.isPreserveLineDelimeters(), lines);
            }
        }
        return this.getHunk().getContents(afterState, this.getConfiguration().isReversed());
    }

    private boolean isEnabled(PatchConfiguration configuration) {
        Patcher patcher = Patcher.getPatcher(configuration);
        if (patcher != null) {
            return patcher.isEnabled(this.fHunk);
        }
        return true;
    }

    public void setMatches(boolean matches) {
        this.fMatches = matches;
    }

    public int getStartPosition() {
        return this.fHunk.getStart(this.getConfiguration().isReversed()) + this.fShift;
    }

    public String getLabel() {
        return this.getHunk().getDescription();
    }

    public InputStream getOriginalContents() {
        String contents = this.getContents(false, false);
        return this.asInputStream(contents);
    }

    protected InputStream asInputStream(String contents) {
        String charSet = this.getCharset();
        return FileDiffResult.asInputStream(contents, charSet);
    }

    public InputStream getPatchedContents() {
        String contents = this.getContents(true, false);
        return this.asInputStream(contents);
    }

    public String getCharset() {
        return this.fDiffResult.getCharset();
    }
}

