/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.internal.CompareContainer;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.DiffImage;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class CompareConfiguration {
    public static final String IGNORE_WHITESPACE = "IGNORE_WHITESPACE";
    public static final String SHOW_PSEUDO_CONFLICTS = "SHOW_PSEUDO_CONFLICTS";
    public static final String USE_OUTLINE_VIEW = "USE_OUTLINE_VIEW";
    private static ImageDescriptor[] fgImages = new ImageDescriptor[16];
    private static Object fgDummy = new Object();
    private static HashMap fgMap = new HashMap(20);
    private static boolean fLeftIsLocal = true;
    private IPreferenceStore fPreferenceStore;
    private ListenerList fListeners = new ListenerList();
    private HashMap fProperties = new HashMap();
    private boolean fLeftEditable = true;
    private boolean fRightEditable = true;
    private String fAncestorLabel;
    private String fLeftLabel;
    private String fRightLabel;
    private Image fAncestorImage;
    private Image fRightImage;
    private Image fLeftImage;
    private Image[] fImages = new Image[16];
    private ICompareContainer fContainer;
    private DefaultLabelProvider labelProvider = new DefaultLabelProvider();

    static {
        if (fLeftIsLocal) {
            CompareConfiguration.fgImages[1] = CompareUIPlugin.getImageDescriptor("ovr16/del_ov.gif");
            CompareConfiguration.fgImages[5] = CompareUIPlugin.getImageDescriptor("ovr16/r_inadd_ov.gif");
            CompareConfiguration.fgImages[9] = CompareUIPlugin.getImageDescriptor("ovr16/r_outadd_ov.gif");
            CompareConfiguration.fgImages[2] = CompareUIPlugin.getImageDescriptor("ovr16/add_ov.gif");
            CompareConfiguration.fgImages[6] = CompareUIPlugin.getImageDescriptor("ovr16/r_indel_ov.gif");
            CompareConfiguration.fgImages[10] = CompareUIPlugin.getImageDescriptor("ovr16/r_outdel_ov.gif");
            CompareConfiguration.fgImages[7] = CompareUIPlugin.getImageDescriptor("ovr16/r_inchg_ov.gif");
            CompareConfiguration.fgImages[11] = CompareUIPlugin.getImageDescriptor("ovr16/r_outchg_ov.gif");
        } else {
            CompareConfiguration.fgImages[1] = CompareUIPlugin.getImageDescriptor("ovr16/add_ov.gif");
            CompareConfiguration.fgImages[5] = CompareUIPlugin.getImageDescriptor("ovr16/inadd_ov.gif");
            CompareConfiguration.fgImages[9] = CompareUIPlugin.getImageDescriptor("ovr16/outadd_ov.gif");
            CompareConfiguration.fgImages[2] = CompareUIPlugin.getImageDescriptor("ovr16/del_ov.gif");
            CompareConfiguration.fgImages[6] = CompareUIPlugin.getImageDescriptor("ovr16/indel_ov.gif");
            CompareConfiguration.fgImages[10] = CompareUIPlugin.getImageDescriptor("ovr16/outdel_ov.gif");
            CompareConfiguration.fgImages[7] = CompareUIPlugin.getImageDescriptor("ovr16/inchg_ov.gif");
            CompareConfiguration.fgImages[11] = CompareUIPlugin.getImageDescriptor("ovr16/outchg_ov.gif");
        }
        CompareConfiguration.fgImages[13] = CompareUIPlugin.getImageDescriptor("ovr16/confadd_ov.gif");
        CompareConfiguration.fgImages[14] = CompareUIPlugin.getImageDescriptor("ovr16/confdel_ov.gif");
        CompareConfiguration.fgImages[15] = CompareUIPlugin.getImageDescriptor("ovr16/confchg_ov.gif");
    }

    public CompareConfiguration(IPreferenceStore prefStore) {
        this.setProperty("LEFT_IS_LOCAL", fLeftIsLocal);
        this.fPreferenceStore = prefStore;
        if (this.fPreferenceStore != null) {
            boolean b = this.fPreferenceStore.getBoolean("org.eclipse.compare.InitiallyShowAncestorPane");
            this.setProperty(ICompareUIConstants.PROP_ANCESTOR_VISIBLE, new Boolean(b));
            b = this.fPreferenceStore.getBoolean("org.eclipse.compare.IgnoreWhitespace");
            this.setProperty(IGNORE_WHITESPACE, new Boolean(b));
        }
    }

    public CompareConfiguration() {
        this(CompareUIPlugin.getDefault().getPreferenceStore());
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    public Image getImage(int kind) {
        if (this.fImages == null) {
            return null;
        }
        Image image = this.fImages[kind & 0xF];
        if (image == null) {
            ImageDescriptor id = fgImages[kind & 0xF];
            if (id != null) {
                image = id.createImage();
            }
            this.fImages[kind & 0xF] = image;
        }
        return image;
    }

    public Image getImage(Image base, int kind) {
        Image b;
        Object key = base;
        if (key == null) {
            key = fgDummy;
        }
        kind &= 0xF;
        Image[] a = (Image[])fgMap.get(key);
        if (a == null) {
            a = new Image[16];
            fgMap.put(key, a);
        }
        if ((b = a[kind]) == null) {
            b = new DiffImage(base, fgImages[kind], 22, !fLeftIsLocal).createImage();
            CompareUI.disposeOnShutdown(b);
            a[kind] = b;
        }
        return b;
    }

    public void dispose() {
        if (this.fImages != null) {
            int i = 0;
            while (i < this.fImages.length) {
                Image image = this.fImages[i];
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
                ++i;
            }
        }
        this.fImages = null;
        this.labelProvider.dispose();
    }

    private void fireChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = null;
        Object[] listeners = this.fListeners.getListeners();
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                IPropertyChangeListener l = (IPropertyChangeListener)listeners[i];
                if (event == null) {
                    event = new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue);
                }
                l.propertyChange(event);
                ++i;
            }
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void setProperty(String key, Object newValue) {
        Object oldValue = this.fProperties.get(key);
        this.fProperties.put(key, newValue);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.fireChange(key, oldValue, newValue);
        }
    }

    public Object getProperty(String key) {
        return this.fProperties.get(key);
    }

    public void setAncestorLabel(String label) {
        this.fAncestorLabel = label;
    }

    public String getAncestorLabel(Object element) {
        return this.labelProvider.getAncestorLabel(element);
    }

    public void setAncestorImage(Image image) {
        this.fAncestorImage = image;
    }

    public Image getAncestorImage(Object element) {
        return this.labelProvider.getAncestorImage(element);
    }

    public void setLeftEditable(boolean editable) {
        this.fLeftEditable = editable;
    }

    public boolean isLeftEditable() {
        return this.fLeftEditable;
    }

    public void setLeftLabel(String label) {
        this.fLeftLabel = label;
    }

    public String getLeftLabel(Object element) {
        return this.labelProvider.getLeftLabel(element);
    }

    public void setLeftImage(Image image) {
        this.fLeftImage = image;
    }

    public Image getLeftImage(Object element) {
        return this.labelProvider.getLeftImage(element);
    }

    public void setRightEditable(boolean editable) {
        this.fRightEditable = editable;
    }

    public boolean isRightEditable() {
        return this.fRightEditable;
    }

    public void setRightLabel(String label) {
        this.fRightLabel = label;
    }

    public String getRightLabel(Object element) {
        return this.labelProvider.getRightLabel(element);
    }

    public void setRightImage(Image image) {
        this.fRightImage = image;
    }

    public Image getRightImage(Object element) {
        return this.labelProvider.getRightImage(element);
    }

    public ICompareContainer getContainer() {
        if (this.fContainer == null) {
            this.fContainer = new CompareContainer();
        }
        return this.fContainer;
    }

    public void setContainer(ICompareContainer container) {
        this.fContainer = container;
    }

    public ICompareInputLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(ICompareInput input, ICompareInputLabelProvider labelProvider) {
        this.labelProvider.setLabelProvider(input, labelProvider);
    }

    public void setDefaultLabelProvider(ICompareInputLabelProvider labelProvider) {
        this.labelProvider.setDefaultLabelProvider(labelProvider);
    }

    private class DefaultLabelProvider
    extends LabelProvider
    implements ICompareInputLabelProvider,
    ILabelProviderListener {
        private Map labelProviders = new HashMap();
        private ICompareInputLabelProvider defaultLabelProvider;

        private DefaultLabelProvider() {
        }

        public Image getAncestorImage(Object input) {
            Image image;
            ICompareInputLabelProvider provider = this.getLabelProvider(input);
            if (provider != null && (image = provider.getAncestorImage(input)) != null) {
                return image;
            }
            return CompareConfiguration.this.fAncestorImage;
        }

        public String getAncestorLabel(Object input) {
            String label;
            ICompareInputLabelProvider provider = this.getLabelProvider(input);
            if (provider != null && (label = provider.getAncestorLabel(input)) != null) {
                return label;
            }
            return CompareConfiguration.this.fAncestorLabel;
        }

        public Image getLeftImage(Object input) {
            Image image;
            ICompareInputLabelProvider provider = this.getLabelProvider(input);
            if (provider != null && (image = provider.getLeftImage(input)) != null) {
                return image;
            }
            return CompareConfiguration.this.fLeftImage;
        }

        public String getLeftLabel(Object input) {
            String label;
            ICompareInputLabelProvider provider = this.getLabelProvider(input);
            if (provider != null && (label = provider.getLeftLabel(input)) != null) {
                return label;
            }
            return CompareConfiguration.this.fLeftLabel;
        }

        public Image getRightImage(Object input) {
            Image image;
            ICompareInputLabelProvider provider = this.getLabelProvider(input);
            if (provider != null && (image = provider.getRightImage(input)) != null) {
                return image;
            }
            return CompareConfiguration.this.fRightImage;
        }

        public String getRightLabel(Object input) {
            String label;
            ICompareInputLabelProvider provider = this.getLabelProvider(input);
            if (provider != null && (label = provider.getRightLabel(input)) != null) {
                return label;
            }
            return CompareConfiguration.this.fRightLabel;
        }

        public ICompareInputLabelProvider getLabelProvider(Object input) {
            ICompareInputLabelProvider lp = (ICompareInputLabelProvider)this.labelProviders.get(input);
            if (lp == null) {
                return this.defaultLabelProvider;
            }
            return lp;
        }

        public void setLabelProvider(ICompareInput input, ICompareInputLabelProvider labelProvider) {
            ICompareInputLabelProvider old = (ICompareInputLabelProvider)this.labelProviders.get(input);
            if (old != null) {
                old.removeListener(this);
            }
            this.labelProviders.put(input, labelProvider);
            labelProvider.addListener(this);
        }

        public Image getImage(Object element) {
            ICompareInput ci;
            Image image;
            Image image2;
            ICompareInputLabelProvider provider = this.getLabelProvider(element);
            if (provider != null && (image2 = provider.getImage(element)) != null) {
                return image2;
            }
            if (element instanceof ICompareInput && (image = (ci = (ICompareInput)element).getImage()) != null) {
                return image;
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            ICompareInput ci;
            String label;
            String label2;
            ICompareInputLabelProvider provider = this.getLabelProvider(element);
            if (provider != null && (label2 = provider.getText(element)) != null) {
                return label2;
            }
            if (element instanceof ICompareInput && (label = (ci = (ICompareInput)element).getName()) != null) {
                return label;
            }
            return super.getText(element);
        }

        public void dispose() {
            Iterator iterator = this.labelProviders.values().iterator();
            while (iterator.hasNext()) {
                ICompareInputLabelProvider lp = (ICompareInputLabelProvider)iterator.next();
                lp.removeListener(this);
            }
            if (this.defaultLabelProvider != null) {
                this.defaultLabelProvider.removeListener(this);
            }
            this.defaultLabelProvider = null;
            this.labelProviders.clear();
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, event.getElements()));
        }

        public void setDefaultLabelProvider(ICompareInputLabelProvider labelProvider) {
            if (this.defaultLabelProvider != null) {
                this.defaultLabelProvider.removeListener(this);
            }
            this.defaultLabelProvider = labelProvider;
            if (this.defaultLabelProvider != null) {
                this.defaultLabelProvider.addListener(this);
            }
        }
    }
}

