/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.compatibility;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;

public class JavaRuntimeVersionChecker
extends AbstractUIPlugin
implements IStartup {
    private static final String ID_PLUGIN = "org.eclipse.mylyn.compatibility";
    private static final String PREF_WARN_DISABLED = "org.eclipse.mylyn.internal.compatibility.warn.disabled";
    private static final float JRE_MIN_VERSION = 1.5f;

    public void earlyStartup() {
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    String minorString;
                    Float versionFloat;
                    String versionString = System.getProperty("java.runtime.version");
                    int minorMinorIndex = versionString.lastIndexOf(46);
                    if (minorMinorIndex != -1 && (versionFloat = new Float(minorString = versionString.substring(0, minorMinorIndex))).compareTo(new Float(1.5f)) < 0 && !JavaRuntimeVersionChecker.this.getPreferenceStore().getBoolean(JavaRuntimeVersionChecker.PREF_WARN_DISABLED)) {
                        MessageDialogWithToggle dialog = MessageDialogWithToggle.openWarning((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"JDK Version Check", (String)"Mylyn was installed but requires Java 5 or later to run. Please download and install the latest Java version and restart.", (String)"Do not warn again", (boolean)false, (IPreferenceStore)JavaRuntimeVersionChecker.this.getPreferenceStore(), (String)JavaRuntimeVersionChecker.PREF_WARN_DISABLED);
                        JavaRuntimeVersionChecker.this.getPreferenceStore().setValue(JavaRuntimeVersionChecker.PREF_WARN_DISABLED, dialog.getToggleState());
                    }
                }
                catch (Throwable t) {
                    StatusManager.getManager().handle((IStatus)new Status(1, JavaRuntimeVersionChecker.ID_PLUGIN, "Could determine JRE version.", t), 1);
                }
            }
        });
    }
}

