/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import org.eclipse.ltk.internal.ui.refactoring.CompositeChangeNode;
import org.eclipse.ltk.internal.ui.refactoring.DefaultChangeNode;
import org.eclipse.ltk.internal.ui.refactoring.PreviewNode;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPreviewChangeFilter;
import org.eclipse.ltk.ui.refactoring.ChangePreviewViewerInput;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;
import org.eclipse.ltk.ui.refactoring.TextEditChangeNode;

public abstract class AbstractChangeNode
extends PreviewNode {
    private final Change fChange;
    private PreviewNode[] fChildren;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static PreviewNode createNode(PreviewNode parent, RefactoringPreviewChangeFilter filter, Change change) {
        if (change instanceof CompositeChange) {
            return new CompositeChangeNode(parent, filter, (CompositeChange)change);
        }
        if (change instanceof TextEditBasedChange) {
            TextEditChangeNode result;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ltk.ui.refactoring.TextEditChangeNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((result = (TextEditChangeNode)change.getAdapter((Class)clazz)) == null) {
                result = new TextEditChangeNode((TextEditBasedChange)change);
            }
            result.initialize(parent);
            return result;
        }
        return new DefaultChangeNode(parent, change);
    }

    public static PreviewNode createNode(PreviewNode parent, Change change) {
        return AbstractChangeNode.createNode(parent, null, change);
    }

    AbstractChangeNode(PreviewNode parent, Change change) {
        super(parent);
        Assert.isNotNull((Object)change);
        this.fChange = change;
    }

    Change getChange() {
        return this.fChange;
    }

    PreviewNode[] getChildren() {
        if (this.fChildren == null) {
            this.fChildren = this.doCreateChildren();
        }
        return this.fChildren;
    }

    abstract PreviewNode[] doCreateChildren();

    public String getText() {
        return this.fChange.getName();
    }

    public ImageDescriptor getImageDescriptor() {
        return RefactoringPluginImages.DESC_OBJS_DEFAULT_CHANGE;
    }

    ChangePreviewViewerDescriptor getChangePreviewViewerDescriptor() throws CoreException {
        return ChangePreviewViewerDescriptor.get(this.fChange);
    }

    void feedInput(IChangePreviewViewer viewer, List categories) throws CoreException {
        viewer.setInput(new ChangePreviewViewerInput(this.fChange));
    }

    void setEnabled(boolean enabled) {
        this.fChange.setEnabled(enabled);
    }

    void setEnabledShallow(boolean enabled) {
        this.fChange.setEnabledShallow(enabled);
    }

    boolean hasOneGroupCategory(List categories) {
        PreviewNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].hasOneGroupCategory(categories)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean hasDerived() {
        if (AbstractChangeNode.hasDerivedResourceChange(this.fChange)) {
            return true;
        }
        PreviewNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].hasDerived()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int getDefaultChangeActive() {
        int result;
        int n = result = this.fChange.isEnabled() ? 2 : 0;
        if (this.fChildren != null) {
            int i = 0;
            while (i < this.fChildren.length) {
                result = ACTIVATION_TABLE[this.fChildren[i].getActive()][result];
                if (result == 1) break;
                ++i;
            }
        }
        return result;
    }

    int getCompositeChangeActive() {
        if (this.fChildren != null && this.fChildren.length > 0) {
            int result = this.fChildren[0].getActive();
            int i = 1;
            while (i < this.fChildren.length) {
                result = ACTIVATION_TABLE[this.fChildren[i].getActive()][result];
                if (result == 1) break;
                ++i;
            }
            return result;
        }
        return 2;
    }

    static boolean hasDerivedResourceChange(Change change) {
        Object modifiedElement = change.getModifiedElement();
        if (modifiedElement instanceof IResource) {
            return ((IResource)modifiedElement).isDerived();
        }
        if (modifiedElement instanceof IAdaptable) {
            IResource resource;
            IAdaptable adaptable = (IAdaptable)modifiedElement;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)adaptable.getAdapter((Class)clazz)) != null) {
                return resource.isDerived();
            }
        }
        return false;
    }
}

