/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;

public class XmlActiveSearchUpdater
implements IResourceChangeListener,
IQueryListener {
    private FileSearchResult fResult;

    public XmlActiveSearchUpdater(FileSearchResult result) {
        this.fResult = result;
        NewSearchUI.addQueryListener((IQueryListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            this.handleDelta(delta);
        }
    }

    private void handleDelta(IResourceDelta d) {
        try {
            d.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    switch (delta.getKind()) {
                        case 1: {
                            return false;
                        }
                        case 2: {
                            IResource res = delta.getResource();
                            if (!(res instanceof IFile)) break;
                            Match[] matches = XmlActiveSearchUpdater.this.fResult.getMatches((Object)res);
                            XmlActiveSearchUpdater.this.fResult.removeMatches(matches);
                            int j = 0;
                            while (j < matches.length) {
                                ++j;
                            }
                            break;
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)e.getStatus());
        }
    }

    public void queryAdded(ISearchQuery query) {
    }

    public void queryRemoved(ISearchQuery query) {
        if (this.fResult.equals(query.getSearchResult())) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            NewSearchUI.removeQueryListener((IQueryListener)this);
        }
    }

    public void queryStarting(ISearchQuery query) {
    }

    public void queryFinished(ISearchQuery query) {
    }
}

