/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IDegreeOfSeparation;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.DegreeOfSeparation;
import org.eclipse.mylyn.internal.context.core.IActiveSearchListener;
import org.eclipse.mylyn.internal.context.core.IActiveSearchOperation;
import org.eclipse.mylyn.internal.java.ui.search.JavaActiveSearchResultUpdater;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.resources.ResourcesUiBridgePlugin;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search2.internal.ui.InternalSearchUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaRelationProvider
extends AbstractRelationProvider {
    public static final String ID_GENERIC = "org.eclipse.mylyn.java.relation";
    public static final String NAME = "Java relationships";
    private static final int DEFAULT_DEGREE = 2;
    private static final List<Job> runningJobs = new ArrayList<Job>();

    public String getGenericId() {
        return ID_GENERIC;
    }

    protected AbstractJavaRelationProvider(String structureKind, String id) {
        super(structureKind, id);
    }

    public List<IDegreeOfSeparation> getDegreesOfSeparation() {
        ArrayList<IDegreeOfSeparation> separations = new ArrayList<IDegreeOfSeparation>();
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("disabled", 0));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("landmark resources", 1));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("interesting resources", 2));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("interesting projects", 3));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("project dependencies", 4));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("entire workspace (slow)", 5));
        return separations;
    }

    protected void findRelated(IInteractionElement node, int degreeOfSeparation) {
        if (node == null) {
            return;
        }
        if (node.getContentType() == null) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.java.ui", "Null content type for: " + node));
            return;
        }
        if (!node.getContentType().equals("java")) {
            return;
        }
        IJavaElement javaElement = JavaCore.create((String)node.getHandleIdentifier());
        if (!this.acceptElement(javaElement) || !javaElement.exists() || javaElement instanceof IInitializer) {
            return;
        }
        IJavaSearchScope scope = this.createJavaSearchScope(javaElement, degreeOfSeparation);
        if (scope != null) {
            this.runJob(node, degreeOfSeparation, this.getId());
        }
    }

    private IJavaSearchScope createJavaSearchScope(IJavaElement element, int degreeOfSeparation) {
        AbstractContextStructureBridge bridge;
        List landmarks = ContextCorePlugin.getContextManager().getActiveLandmarks();
        List interestingElements = ContextCorePlugin.getContextManager().getActiveContext().getInteresting();
        HashSet<Object> searchElements = new HashSet<Object>();
        int includeMask = 1;
        if (degreeOfSeparation == 1) {
            for (IInteractionElement landmark : landmarks) {
                IJavaElement landmarkElement;
                Object o;
                if (!this.includeNodeInScope(landmark, bridge = ContextCorePlugin.getDefault().getStructureBridge(landmark.getContentType())) || !((o = bridge.getObjectForHandle(landmark.getHandleIdentifier())) instanceof IJavaElement) || !(landmarkElement = (IJavaElement)o).exists()) continue;
                if (landmarkElement instanceof IMember && !landmark.getInterest().isPropagated()) {
                    searchElements.add(((IMember)landmarkElement).getCompilationUnit());
                    continue;
                }
                if (!(landmarkElement instanceof ICompilationUnit)) continue;
                searchElements.add(landmarkElement);
            }
        } else if (degreeOfSeparation == 2) {
            for (IInteractionElement interesting : interestingElements) {
                IJavaElement interestingElement;
                Object object;
                if (!this.includeNodeInScope(interesting, bridge = ContextCorePlugin.getDefault().getStructureBridge(interesting.getContentType())) || !((object = bridge.getObjectForHandle(interesting.getHandleIdentifier())) instanceof IJavaElement) || !(interestingElement = (IJavaElement)object).exists()) continue;
                if (interestingElement instanceof IMember && !interesting.getInterest().isPropagated()) {
                    searchElements.add(((IMember)interestingElement).getCompilationUnit());
                    continue;
                }
                if (!(interestingElement instanceof ICompilationUnit)) continue;
                searchElements.add(interestingElement);
            }
        } else if (degreeOfSeparation == 3 || degreeOfSeparation == 4) {
            for (IInteractionElement interesting : interestingElements) {
                IJavaProject javaProject;
                IProject project;
                IResource resource;
                if (!this.includeNodeInScope(interesting, bridge = ContextCorePlugin.getDefault().getStructureBridge(interesting.getContentType())) || (resource = ResourcesUiBridgePlugin.getDefault().getResourceForElement(interesting, true)) == null || (project = resource.getProject()) == null || !JavaProject.hasJavaNature((IProject)project) || !project.exists() || (javaProject = JavaCore.create((IProject)project)) == null || !javaProject.exists()) continue;
                searchElements.add(javaProject);
            }
            if (degreeOfSeparation == 4) {
                includeMask = 7;
            }
        } else if (degreeOfSeparation == 5) {
            return SearchEngine.createWorkspaceScope();
        }
        if (searchElements.size() == 0) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[searchElements.size()];
        int j = 0;
        Iterator iterator = searchElements.iterator();
        while (iterator.hasNext()) {
            IJavaElement searchElement;
            elements[j] = searchElement = (IJavaElement)iterator.next();
            ++j;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)includeMask);
    }

    private boolean includeNodeInScope(IInteractionElement interesting, AbstractContextStructureBridge bridge) {
        if (interesting == null || bridge == null) {
            return false;
        }
        if (interesting.getContentType() == null) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.java.ui", "Null content type for: " + interesting.getHandleIdentifier()));
            return false;
        }
        return interesting.getContentType().equals("java") || bridge.isDocument(interesting.getHandleIdentifier());
    }

    protected boolean acceptResultElement(IJavaElement element) {
        return !(element instanceof IImportDeclaration);
    }

    protected boolean acceptElement(IJavaElement javaElement) {
        return javaElement != null && (javaElement instanceof IMember || javaElement instanceof IType);
    }

    private void runJob(final IInteractionElement node, final int degreeOfSeparation, String kind) {
        int limitTo = 0;
        if (kind.equals("org.eclipse.mylyn.java.relation.references")) {
            limitTo = 2;
        } else if (kind.equals("org.eclipse.mylyn.java.relation.implementors")) {
            limitTo = 1;
        } else if (kind.equals("org.eclipse.mylyn.java.relation.junitreferences")) {
            limitTo = 2;
        } else if (kind.equals("org.eclipse.mylyn.java.relation.readaccess")) {
            limitTo = 2;
        } else if (kind.equals("org.eclipse.mylyn.java.relation.writeaccess")) {
            limitTo = 2;
        }
        JavaSearchOperation query = (JavaSearchOperation)this.getSearchOperation(node, limitTo, degreeOfSeparation);
        if (query == null) {
            return;
        }
        JavaSearchJob job = new JavaSearchJob(query.getLabel(), query);
        query.addListener(new IActiveSearchListener(){
            private boolean gathered = false;

            public boolean resultsGathered() {
                return this.gathered;
            }

            public void searchCompleted(List l) {
                if (l == null) {
                    return;
                }
                ArrayList<IJavaElement> relatedHandles = new ArrayList<IJavaElement>();
                Object[] elements = l.toArray();
                int i = 0;
                while (i < elements.length) {
                    if (elements[i] instanceof IJavaElement) {
                        relatedHandles.add((IJavaElement)elements[i]);
                    }
                    ++i;
                }
                for (IJavaElement element : relatedHandles) {
                    if (!AbstractJavaRelationProvider.this.acceptResultElement(element)) continue;
                    AbstractJavaRelationProvider.this.incrementInterest(node, "java", element.getHandleIdentifier(), degreeOfSeparation);
                }
                this.gathered = true;
                AbstractJavaRelationProvider.this.searchCompleted(node);
            }
        });
        InternalSearchUI.getInstance();
        runningJobs.add(job);
        job.setPriority(40);
        job.schedule();
    }

    public IActiveSearchOperation getSearchOperation(IInteractionElement node, int limitTo, int degreeOfSeparation) {
        IJavaElement javaElement = JavaCore.create((String)node.getHandleIdentifier());
        if (javaElement == null || !javaElement.exists()) {
            return null;
        }
        IJavaSearchScope scope = this.createJavaSearchScope(javaElement, degreeOfSeparation);
        if (scope == null) {
            return null;
        }
        ElementQuerySpecification specs = new ElementQuerySpecification(javaElement, limitTo, scope, "Mylyn degree of separation: " + degreeOfSeparation);
        return new JavaSearchOperation((QuerySpecification)specs);
    }

    public void stopAllRunningJobs() {
        for (Job j : runningJobs) {
            j.cancel();
        }
        runningJobs.clear();
    }

    protected int getDefaultDegreeOfSeparation() {
        return 2;
    }

    protected static class JavaSearchJob
    extends Job {
        private JavaSearchOperation op;

        public JavaSearchJob(String name, JavaSearchOperation op) {
            super(name);
            this.op = op;
        }

        protected IStatus run(IProgressMonitor monitor) {
            return this.op.run(monitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class JavaSearchOperation
    extends JavaSearchQuery
    implements IActiveSearchOperation {
        private ISearchResult result = null;
        private List<IActiveSearchListener> listeners = new ArrayList<IActiveSearchListener>();

        public ISearchResult getSearchResult() {
            if (this.result == null) {
                this.result = new JavaSearchResult((JavaSearchQuery)this);
            }
            new JavaActiveSearchResultUpdater((JavaSearchResult)this.result);
            return this.result;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                IStatus runStatus = super.run(monitor);
                ISearchResult result = this.getSearchResult();
                if (result instanceof JavaSearchResult) {
                    Object[] objs = ((JavaSearchResult)result).getElements();
                    if (objs == null) {
                        this.notifySearchCompleted(null);
                    } else {
                        ArrayList<Object> l = new ArrayList<Object>();
                        int i = 0;
                        while (i < objs.length) {
                            l.add(objs[i]);
                            ++i;
                        }
                        this.notifySearchCompleted(l);
                    }
                }
                return runStatus;
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Java search failed", t));
                Status status = new Status(2, "org.eclipse.mylyn.core", 0, "could not run Java search", null);
                this.notifySearchCompleted(null);
                return status;
            }
        }

        public JavaSearchOperation(QuerySpecification data) {
            super(data);
        }

        public void addListener(IActiveSearchListener l) {
            this.listeners.add(l);
        }

        public void removeListener(IActiveSearchListener l) {
            this.listeners.remove(l);
        }

        public void notifySearchCompleted(List<Object> l) {
            for (IActiveSearchListener listener : this.listeners) {
                listener.searchCompleted(l);
            }
        }
    }
}

