/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.internal.resources.Marker;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.java.ui.search.JUnitReferencesProvider;
import org.eclipse.mylyn.internal.java.ui.search.JavaImplementorsProvider;
import org.eclipse.mylyn.internal.java.ui.search.JavaReadAccessProvider;
import org.eclipse.mylyn.internal.java.ui.search.JavaReferencesProvider;
import org.eclipse.mylyn.internal.java.ui.search.JavaWriteAccessProvider;
import org.eclipse.mylyn.internal.resources.ui.ResourceStructureBridge;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.ui.internal.WorkingSet;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaStructureBridge
extends AbstractContextStructureBridge {
    public static final String CONTENT_TYPE = "java";
    public List<AbstractRelationProvider> providers = new ArrayList<AbstractRelationProvider>();

    public JavaStructureBridge() {
        this.providers.add(new JavaReferencesProvider());
        this.providers.add(new JavaImplementorsProvider());
        this.providers.add(new JavaReadAccessProvider());
        this.providers.add(new JavaWriteAccessProvider());
        this.providers.add(new JUnitReferencesProvider());
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public Object getAdaptedParent(Object object) {
        if (object instanceof IFile) {
            IFile file = (IFile)object;
            return JavaCore.create((IResource)file.getParent());
        }
        return super.getAdaptedParent(object);
    }

    public String getParentHandle(String handle) {
        IJavaElement javaElement = (IJavaElement)this.getObjectForHandle(handle);
        if (javaElement != null && javaElement.getParent() != null) {
            return this.getHandleIdentifier(javaElement.getParent());
        }
        return null;
    }

    public List<String> getChildHandles(String handle) {
        IJavaElement element;
        Object object = this.getObjectForHandle(handle);
        if (object instanceof IJavaElement && (element = (IJavaElement)object) instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                List resourceChildren;
                IJavaElement[] children = parent.getChildren();
                ArrayList<String> childHandles = new ArrayList<String>();
                int i = 0;
                while (i < children.length) {
                    String childHandle = this.getHandleIdentifier(children[i]);
                    if (childHandle != null) {
                        childHandles.add(childHandle);
                    }
                    ++i;
                }
                AbstractContextStructureBridge parentBridge = ContextCorePlugin.getDefault().getStructureBridge(this.parentContentType);
                if (parentBridge != null && parentBridge instanceof ResourceStructureBridge && element.getElementType() < 7 && !(resourceChildren = parentBridge.getChildHandles(handle)).isEmpty()) {
                    childHandles.addAll(resourceChildren);
                }
                return childHandles;
            }
            catch (JavaModelException javaModelException) {
                AbstractContextStructureBridge parentBridge = ContextCorePlugin.getDefault().getStructureBridge("resource");
                return parentBridge.getChildHandles(handle);
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not get children", (Throwable)e));
            }
        }
        return Collections.emptyList();
    }

    public Object getObjectForHandle(String handle) {
        try {
            return JavaCore.create((String)handle);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.java.ui", "Could not create java element for handle: " + handle, t));
            return null;
        }
    }

    public String getHandleIdentifier(Object object) {
        if (object instanceof IJavaElement) {
            return ((IJavaElement)object).getHandleIdentifier();
        }
        if (object instanceof IAdaptable) {
            Object adapter = ((IAdaptable)object).getAdapter(IJavaElement.class);
            if (adapter instanceof IJavaElement) {
                return ((IJavaElement)adapter).getHandleIdentifier();
            }
        } else if (this.isWtpClass(object)) {
            return this.getWtpElementHandle(object);
        }
        return null;
    }

    private String getWtpElementHandle(Object object) {
        Class<?> objectClass = object.getClass();
        try {
            Method getProjectMethod = objectClass.getMethod("getProject", new Class[0]);
            Object javaProject = getProjectMethod.invoke(object, new Object[0]);
            if (javaProject instanceof IJavaProject) {
                return ((IJavaElement)javaProject).getHandleIdentifier();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean isWtpClass(Object object) {
        try {
            return object != null && object.getClass().getSimpleName().equals("CompressedJavaProject");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String getLabel(Object object) {
        if (object instanceof IJavaElement) {
            return ((IJavaElement)object).getElementName();
        }
        return "";
    }

    public boolean canBeLandmark(String handle) {
        IJavaElement element = (IJavaElement)this.getObjectForHandle(handle);
        return (element instanceof IMember || element instanceof IType) && element.exists();
    }

    public boolean acceptsObject(Object object) {
        if (object instanceof IResource) {
            Object adapter = ((IResource)object).getAdapter(IJavaElement.class);
            return adapter instanceof IJavaElement;
        }
        boolean accepts = object instanceof IJavaElement || object instanceof PackageFragmentRootContainer || object instanceof ClassPathContainer.RequiredProjectWrapper || object instanceof JarEntryFile || object instanceof IPackageFragment || object instanceof WorkingSet || this.isWtpClass(object);
        return accepts;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean canFilter(Object object) {
        if (object instanceof ClassPathContainer.RequiredProjectWrapper) {
            return true;
        }
        if (object instanceof PackageFragmentRootContainer) {
            PackageFragmentRootContainer container = (PackageFragmentRootContainer)object;
            IAdaptable[] children = container.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof JarPackageFragmentRoot) {
                    JarPackageFragmentRoot element = (JarPackageFragmentRoot)children[i];
                    IInteractionElement node = ContextCorePlugin.getContextManager().getElement(element.getHandleIdentifier());
                    if (node != null && node.getInterest().isInteresting()) {
                        return false;
                    }
                }
                ++i;
            }
        } else if (object instanceof WorkingSet) {
            try {
                WorkingSet workingSet = (WorkingSet)object;
                IAdaptable[] elements = workingSet.getElements();
                int i = 0;
                while (i < elements.length) {
                    IAdaptable adaptable = elements[i];
                    IInteractionElement interactionElement = ContextCorePlugin.getContextManager().getElement(this.getHandleIdentifier(adaptable));
                    if (interactionElement != null && interactionElement.getInterest().isInteresting()) {
                        return false;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean isDocument(String handle) {
        IJavaElement element = (IJavaElement)this.getObjectForHandle(handle);
        return element instanceof ICompilationUnit || element instanceof IClassFile;
    }

    public String getHandleForOffsetInObject(Object object, int offset) {
        ICompilationUnit compilationUnit;
        IMarker marker;
        int charStart;
        block14: {
            charStart = 0;
            if (object instanceof ConcreteMarker) {
                marker = ((ConcreteMarker)object).getMarker();
            } else if (object instanceof Marker) {
                marker = (Marker)object;
            } else {
                return null;
            }
            Integer attribute = marker.getAttribute("charStart", 0);
            if (attribute instanceof Integer) {
                charStart = attribute;
            }
            compilationUnit = null;
            IResource resource = marker.getResource();
            if (!(resource instanceof IFile)) break block14;
            IFile file = (IFile)resource;
            if (file.getFileExtension().equals(CONTENT_TYPE)) {
                compilationUnit = JavaCore.createCompilationUnitFrom((IFile)file);
                break block14;
            }
            return null;
        }
        try {
            if (compilationUnit != null) {
                IJavaElement javaElement = compilationUnit.getElementAt(charStart);
                if (javaElement != null) {
                    if (javaElement instanceof IImportDeclaration) {
                        javaElement = javaElement.getParent().getParent();
                    }
                    return javaElement.getHandleIdentifier();
                }
                return null;
            }
            return null;
        }
        catch (JavaModelException ex) {
            if (!ex.isDoesNotExist()) {
                ExceptionHandler.handle((CoreException)((Object)ex), (String)"error", (String)"could not find java element");
            }
            return null;
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not find element for: " + marker, t));
            return null;
        }
    }

    public String getContentType(String elementHandle) {
        return this.getContentType();
    }

    public boolean containsProblem(IInteractionElement node) {
        try {
            IJavaElement element = (IJavaElement)this.getObjectForHandle(node.getHandleIdentifier());
            switch (element.getElementType()) {
                case 2: 
                case 3: {
                    return this.getErrorTicksFromMarkers(element.getResource(), 2, null);
                }
                case 4: 
                case 5: 
                case 6: {
                    return this.getErrorTicksFromMarkers(element.getResource(), 1, null);
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    ICompilationUnit cu = (ICompilationUnit)element.getAncestor(5);
                    if (cu != null) {
                        return this.getErrorTicksFromMarkers(element.getResource(), 1, null);
                    }
                    break;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean getErrorTicksFromMarkers(IResource res, int depth, ISourceReference sourceElement) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return false;
        }
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        if (markers != null) {
            int i = 0;
            while (i < markers.length) {
                int priority;
                IMarker curr = markers[i];
                if (sourceElement == null && (priority = curr.getAttribute("severity", -1)) == 2) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

